% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-igv.R
\name{scale_color_igv}
\alias{scale_color_igv}
\alias{scale_colour_igv}
\alias{scale_fill_igv}
\title{Integrative Genomics Viewer (IGV) Color Scales}
\usage{
scale_color_igv(palette = c("default", "alternating"), alpha = 1, ...)

scale_colour_igv(palette = c("default", "alternating"), alpha = 1, ...)

scale_fill_igv(palette = c("default", "alternating"), alpha = 1, ...)
}
\arguments{
\item{palette}{Palette type.
There are two available options:
\code{"default"} (51-color palette);
\code{"alternating"} (2-color palette).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices]{rgb}} for details.}

\item{...}{additional parameters for \code{\link[ggplot2]{discrete_scale}}}
}
\description{
See \code{\link{pal_igv}} for details.
}
\examples{
library("ggplot2")
data("diamonds")

p1 <- ggplot(
  subset(diamonds, carat >= 2.2),
  aes(x = table, y = price, colour = cut)
) +
  geom_point(alpha = 0.7) +
  geom_smooth(method = "loess", alpha = 0.1, size = 1, span = 1) +
  theme_bw()

p2 <- ggplot(
  subset(diamonds, carat > 2.2 & depth > 55 & depth < 70),
  aes(x = depth, fill = cut)
) +
  geom_histogram(colour = "black", binwidth = 1, position = "dodge") +
  theme_bw()

p1 + scale_color_igv()
p2 + scale_fill_igv()

p1 + scale_colour_manual(
  values = rep(pal_igv("alternating")(2), times = 3)
)
p2 + scale_fill_manual(
  values = rep(pal_igv("alternating")(2), times = 3)
)
}
\author{
Nan Xiao <\email{me@nanx.me}> |
<\href{https://nanx.me}{https://nanx.me}>
}
