% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete.06.d3.R
\name{scale_color_d3}
\alias{scale_color_d3}
\alias{scale_colour_d3}
\alias{scale_fill_d3}
\title{D3.js Color Scales}
\usage{
scale_color_d3(palette = c("category10", "category20", "category20b",
  "category20c"), alpha = 1, ...)

scale_colour_d3(palette = c("category10", "category20", "category20b",
  "category20c"), alpha = 1, ...)

scale_fill_d3(palette = c("category10", "category20", "category20b",
  "category20c"), alpha = 1, ...)
}
\arguments{
\item{palette}{Palette type.
There are 4 available options:
\code{"category10"} (10-color palette);
\code{"category20"} (20-color palette);
\code{"category20b"} (20-color palette);
\code{"category20c"} (20-color palette).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices]{rgb}} for details.}

\item{...}{additional parameters for \code{\link[ggplot2]{discrete_scale}}}
}
\description{
See \code{\link{pal_d3}} for details.
}
\examples{
library("ggplot2")
data("diamonds")

p1 = ggplot(subset(diamonds, carat >= 2.2),
            aes(x = table, y = price, colour = cut)) +
  geom_point(alpha = 0.7) +
  geom_smooth(method = "loess", alpha = 0.1, size = 1, span = 1) +
  theme_bw()

p2 = ggplot(subset(diamonds, carat > 2.2 & depth > 55 & depth < 70),
            aes(x = depth, fill = cut)) +
  geom_histogram(colour = "black", binwidth = 1, position = "dodge") +
  theme_bw()

p1 + scale_color_d3()
p2 + scale_fill_d3()

p1 + scale_color_d3(palette = "category20")
p2 + scale_fill_d3(palette = "category20")

p1 + scale_color_d3(palette = "category20b")
p2 + scale_fill_d3(palette = "category20b")

p1 + scale_color_d3(palette = "category20c")
p2 + scale_fill_d3(palette = "category20c")
}
\author{
Nan Xiao <\email{me@nanx.me}> |
<\href{http://nanx.me}{http://nanx.me}>
}
\references{
\url{https://github.com/d3/d3-3.x-api-reference/blob/master/Ordinal-Scales.md}
}

