% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_edge_size.R
\name{scale_edge_size}
\alias{scale_edge_size}
\alias{scale_edge_size_continuous}
\alias{scale_edge_radius}
\alias{scale_edge_size_discrete}
\alias{scale_edge_size_area}
\alias{scale_edge_size_manual}
\alias{scale_edge_size_identity}
\title{Edge size scales}
\usage{
scale_edge_size_continuous(..., range = c(1, 6))

scale_edge_radius(..., range = c(1, 6))

scale_edge_size(..., range = c(1, 6))

scale_edge_size_discrete(..., range = c(2, 6))

scale_edge_size_area(..., max_size = 6)

scale_edge_size_manual(..., values)

scale_edge_size_identity(..., guide = "none")
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:continuous_scale]{continuous_scale}}
  \describe{
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks.
}}
    \item{\code{oob}}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds).
\item The default (\code{\link[scales:censor]{scales::censor()}}) replaces out of
bounds values with \code{NA}.
\item \code{\link[scales:squish]{scales::squish()}} for squishing out of bounds values into range.
\item \code{\link[scales:squish_infinite]{scales::squish_infinite()}} for squishing infitite values into range.
}}
    \item{\code{na.value}}{Missing values will be replaced with this value.}
    \item{\code{expand}}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
    \item{\code{position}}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{range}{a numeric vector of length 2 that specifies the minimum and
maximum size of the plotting symbol after transformation.}

\item{max_size}{Size of largest points.}

\item{values}{a set of aesthetic values to map data values to. The values
will be matched in order (usually alphabetical) with the limits of the
scale, or with \code{breaks} if provided. If this is a named vector, then the
values will be matched based on the names instead. Data values that don't
match will be given \code{na.value}.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
}
\value{
A ggproto object inheriting from \code{Scale}
}
\description{
This set of scales defines new size scales for edge geoms equivalent to the
ones already defined by ggplot2. See \code{\link[ggplot2:scale_size]{ggplot2::scale_size()}} for
more information. The different geoms will know whether to use edge scales or
the standard scales so it is not necessary to write \code{edge_size} in
the call to the geom - just use \code{size}.
}
\note{
In ggplot2 size conflates both line width and point size into one
scale. In ggraph there is also a width scale (\code{\link[=scale_edge_width]{scale_edge_width()}})
that is used for linewidth. As edges are often represented by lines the width
scale is the most common.
}
\seealso{
Other scale_edge_*: 
\code{\link{scale_edge_alpha}()},
\code{\link{scale_edge_colour}},
\code{\link{scale_edge_fill}},
\code{\link{scale_edge_linetype}()},
\code{\link{scale_edge_shape}()},
\code{\link{scale_edge_width}()},
\code{\link{scale_label_size}()}
}
\concept{scale_edge_*}
