% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate_axis_text.R
\name{rotate_axis_text}
\alias{rotate_axis_text}
\alias{rotate_x_text}
\alias{rotate_y_text}
\title{Rotate Axes Text}
\usage{
rotate_x_text(angle = 90, hjust = NULL, vjust = NULL, ...)

rotate_y_text(angle = 90, hjust = NULL, vjust = NULL, ...)
}
\arguments{
\item{angle}{numeric value specifying the rotation angle. Default is 90 for vertical x-axis text.}

\item{hjust}{horizontal justification (in [0, 1]).}

\item{vjust}{vertical justification (in [0, 1]).}

\item{...}{other arguments to pass to the function
\code{\link[ggplot2:element]{element_text}()}.}
}
\description{
Rotate the x-axis text (tick mark labels).
\itemize{
\item \code{rotate_x_text}(): Rotate x axis text.
\item \code{rotate_y_text}(): Rotate y axis text.
}
}
\examples{
# Load data
data("ToothGrowth")
df <- ToothGrowth

# Basic plot
p <- ggboxplot(df, x = "dose", y = "len")
p
# Vertical x axis text
p + rotate_x_text()
# Set rotation angle to 45
p + rotate_x_text(45)
p + rotate_y_text(45)

}
