% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpmisc.R
\docType{package}
\name{ggpmisc-package}
\alias{ggpmisc}
\alias{ggpmisc-package}
\title{ggpmisc: Miscellaneous Extensions to 'ggplot2'}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Extensions to 'ggplot2' respecting the grammar of graphics paradigm. Statistics: locate and tag peaks and valleys; label plot with the equation of a fitted polynomial or other types of models including major axis, quantile and robust and resistant regression. Labels for P-value, R^2 or adjusted R^2 or information criteria for fitted models; parametric and non-parametric correlation; label with ANOVA table for fitted models; label with summary table for fitted models; annotations for multiple comparisons with adjusted P-values. Model fit classes for which suitable methods are provided by package 'broom' and 'broom.mixed' are supported as well as user-defined wrappers on model fit functions. Scales and stats to build volcano and quadrant plots based on outcomes, fold changes, p-values and false discovery rates.
}
\details{
The new facilities for cleanly defining new stats and geoms added to
  'ggplot2' in version 2.0.0 and the support for nested data frames and lists
  and new syntax for mapping computed values to aesthetics added to 'ggplot2'
  in version 3.0.0 are used in this package's code, as well as some features
  added in more recent updates including 3.5.0. This means that current
  'ggpmisc' versions require recent versions of ggplot2.

Extensions provided:
\itemize{
\item Function for conversion of time series data into tibbles that can be
plotted with ggplot.
\item \code{ggplot()} method for time series data.
\item Stats for locating and tagging "peaks" and "valleys" (local or global
 maxima and minima).
\item Stat for generating labels from model fit objects, including
formatted equations. By default labels are R's plotmath expressions but LaTeX,
markdown and plain text formatted labels are optionaly assembled.
\item Stats for extracting information from a any model fit supported by
package 'broom' and using it to generate various annotations and data labels.
\item Stat for computing and generating labels for the results from multiple
comparisons, including adjusted \emph{P}-values.}

The stats for peaks and valleys are coded so as to work correctly both with
numeric and POSIXct variables mapped to the x aesthetic. Special handling was
needed as text labels are generated from the data.
}
\note{
The signatures of \code{stat_peaks()} and \code{stat_valleys()} from
  'ggpmisc' are identical to those of \code{stat_peaks} and
  \code{stat_valleys} from package 'ggspectra' but the variables returned are
  a subset as special handling of values related to light spectra is missing.
  Furthermore the \code{stat_peaks()} and \code{stat_valleys()} from package
  'ggpmisc' work correctly when date or datetime values are mapped to the
  \emph{x} statistic, while those from package 'ggspectra' do not generate
  correct labels in this case.
}
\examples{
library(tibble)

ggplot(lynx, as.numeric = FALSE) + geom_line() +
stat_peaks(colour = "red") +
  stat_peaks(geom = "text", colour = "red", angle = 66,
             hjust = -0.1, x.label.fmt = "\%Y") +
  ylim(NA, 8000)

formula <- y ~ poly(x, 2, raw = TRUE)
ggplot(cars, aes(speed, dist)) +
  geom_point() +
  stat_poly_line(formula = formula) +
  stat_poly_eq(use_label("eq", "R2", "P"),
               formula = formula,
               parse = TRUE) +
  labs(x = expression("Speed, "*x~("mph")),
       y = expression("Stopping distance, "*y~("ft")))

formula <- y ~ x
ggplot(PlantGrowth, aes(group, weight)) +
  stat_summary(fun.data = "mean_se") +
  stat_fit_tb(method = "lm",
              method.args = list(formula = formula),
              tb.type = "fit.anova",
              tb.vars = c(Term = "term", "df", "M.S." = "meansq",
                          "italic(F)" = "statistic",
                          "italic(p)" = "p.value"),
              tb.params = c("Group" = 1, "Error" = 2),
              table.theme = ttheme_gtbw(parse = TRUE)) +
  labs(x = "Group", y = "Dry weight of plants") +
  theme_classic()

}
\references{
Package suite 'r4photobiology' web site at
\url{https://www.r4photobiology.info/}\cr Package 'ggplot2' documentation at
\url{https://ggplot2.tidyverse.org/}\cr Package 'ggplot2' source code at
\url{https://github.com/tidyverse/ggplot2}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.r4photobiology.info/ggpmisc/}
  \item \url{https://github.com/aphalo/ggpmisc}
  \item Report bugs at \url{https://github.com/aphalo/ggpmisc/issues}
}

}
\author{
\strong{Maintainer}: Pedro J. Aphalo \email{pedro.aphalo@helsinki.fi} (\href{https://orcid.org/0000-0003-3385-972X}{ORCID})

Other contributors:
\itemize{
  \item Kamil Slowikowski (\href{https://orcid.org/0000-0002-2843-6370}{ORCID}) [contributor]
  \item Samer Mouksassi \email{samermouksassi@gmail.com} (\href{https://orcid.org/0000-0002-7152-6654}{ORCID}) [contributor]
}

}
