% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-ma-eq.R
\name{stat_ma_eq}
\alias{stat_ma_eq}
\title{Equation, p-value, R^2 of major axis regression}
\usage{
stat_ma_eq(
  mapping = NULL,
  data = NULL,
  geom = "text_npc",
  position = "identity",
  ...,
  method = "MA",
  formula = NULL,
  range.y = NULL,
  range.x = NULL,
  nperm = 99,
  eq.with.lhs = TRUE,
  eq.x.rhs = NULL,
  small.r = FALSE,
  small.p = FALSE,
  coef.digits = 3,
  coef.keep.zeros = TRUE,
  rr.digits = 2,
  p.digits = max(1, ceiling(log10(nperm))),
  label.x = "left",
  label.y = "top",
  hstep = 0,
  vstep = NULL,
  output.type = NULL,
  na.rm = FALSE,
  orientation = NA,
  parse = NULL,
  show.legend = FALSE,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}}. Only needs to be set at the layer level if you
are overriding the plot defaults.}

\item{data}{A layer specific dataset, only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{method}{character "MA", "SMA" , "RMA" and "OLS".}

\item{formula}{a formula object. Using aesthetic names \code{x} and \code{y}
instead of original variable names.}

\item{range.y, range.x}{character Pass "relative" or "interval" if method
"RMA" is to be computed.}

\item{nperm}{integer Number of permutation used to estimate significance.}

\item{eq.with.lhs}{If \code{character} the string is pasted to the front of
the equation label before parsing or a \code{logical} (see note).}

\item{eq.x.rhs}{\code{character} this string will be used as replacement for
\code{"x"} in the model equation when generating the label before parsing
it.}

\item{small.r, small.p}{logical Flags to switch use of lower case r and p for
coefficient of determination and p-value.}

\item{coef.digits}{integer Number of significant digits to use for
the fitted coefficients.}

\item{coef.keep.zeros}{logical Keep or drop trailing zeros when formatting
the fitted coefficients and F-value.}

\item{rr.digits, p.digits}{integer Number of digits after the decimal point to
use for R^2 and P-value in labels.}

\item{label.x, label.y}{\code{numeric} with range 0..1 "normalized parent
coordinates" (npc units) or character if using \code{geom_text_npc()} or
\code{geom_label_npc()}. If using \code{geom_text()} or \code{geom_label()}
numeric in native data units. If too short they will be recycled.}

\item{hstep, vstep}{numeric in npc units, the horizontal and vertical step
used between labels for different groups.}

\item{output.type}{character One of "expression", "LaTeX", "text",
"markdown" or "numeric".}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{orientation}{character Either "x" or "y" controlling the default for
\code{formula}.}

\item{parse}{logical Passed to the geom. If \code{TRUE}, the labels will be
parsed into expressions and displayed as described in \code{?plotmath}.
Default is \code{TRUE} if \code{output.type = "expression"} and
\code{FALSE} otherwise.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\description{
\code{stat_ma_eq} fits model II regressions. From the fitted model it
generates several labels including the equation, p-value,
coefficient of determination (R^2), and number of observations.
}
\details{
This stat can be used to automatically annotate a plot with R^2,
  P_value, n and/or the fitted model equation. It supports linear major axis
  (MA), standard major axis (SMA) and ranged major axis (RMA) regression by
  means of function \code{\link[lmodel2]{lmodel2}}. Please see the
  documentation, including the vignette of package 'lmodel2' for details.
  The parameters in \code{stat_ma_eq()} follow the same naming as in function
  \code{lmodel2()}.

  A ggplot statistic receives as \code{data} a data frame that is not the one
  passed as argument by the user, but instead a data frame with the variables
  mapped to aesthetics. \code{stat_ma_eq()} mimics how \code{stat_smooth()}
  works, except that only linear regression can be fitted. Similarly to these
  statistics the model fits respect grouping, so the scales used for \code{x}
  and \code{y} should both be continuous scales rather than discrete.
}
\note{
For backward compatibility a logical is accepted as argument for
  \code{eq.with.lhs}. If \code{TRUE}, the default is used, either
  \code{"x"} or \code{"y"}, depending on the argument passed to \code{formula}.
  However, \code{"x"} or \code{"y"} can be substituted by providing a
  suitable replacement character string through \code{eq.x.rhs}.
  Parameter \code{orientation} is redundant as it only affects the default
  for \code{formula} but is included for consistency with
  \code{ggplot2::stat_smooth()}.
}
\section{Aesthetics}{
 \code{stat_ma_eq} understands \code{x} and \code{y}, to
  be referenced in the \code{formula} while the \code{weight} aesthetic is
  ignored. Both \code{x} and \code{y} must be mapped to \code{numeric}
  variables. In addition, the aesthetics understood by the geom
  (\code{"text"} is the default) are understood and grouping respected.
}

\section{Computed variables}{

If output.type different from \code{"numeric"} the returned tibble contains
columns listed below. If the fitted model does not contain a given value,
the label is set to \code{character(0L)}.
\describe{
  \item{x,npcx}{x position}
  \item{y,npcy}{y position}
  \item{eq.label}{equation for the fitted polynomial as a character string to be parsed}
  \item{rr.label}{\eqn{R^2} of the fitted model as a character string to be parsed}
  \item{p.value.label}{P-value for the F-value above.}
  \item{n.label}{Number of observations used in the fit.}
  \item{grp.label}{Set according to mapping in \code{aes}.}
  \item{r.squared, p.value, n}{numeric values, from the model fit object}}

If output.type is \code{"numeric"} the returned tibble contains columns
listed below. If the model fit function used does not return a value,
the variable is set to \code{NA_real_}.
\describe{
  \item{x,npcx}{x position}
  \item{y,npcy}{y position}
  \item{coef.ls}{list containing the "coefficients" matrix from the summary of the fit object}
  \item{r.squared, adj.r.squared, f.value, f.df1, f.df2, p.value, AIC, BIC, n}{numeric values, from the model fit object}
  \item{grp.label}{Set according to mapping in \code{aes}.}
  \item{b_0.constant}{TRUE is polynomial is forced through the origin}
  \item{b_i}{One or two columns with the coefficient estimates}}

To explore the computed values returned for a given input we suggest the use
of \code{\link[gginnards]{geom_debug}} as shown in the last examples below.
}

\examples{
# generate artificial data
set.seed(98723)
my.data <- data.frame(x = rnorm(100) + (0:99) / 10 - 5,
                      y = rnorm(100) + (0:99) / 10 - 5,
                      group = c("A", "B"))

# using defaults (major axis regression)
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line() +
  stat_ma_eq()

# using major axis regression
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(method = "MA") +
  stat_ma_eq(aes(label =
    paste(after_stat(eq.label),
          after_stat(p.value.label),
          sep = "*\", \"*")),
          method = "MA")

# using standard major axis regression
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(method = "SMA") +
  stat_ma_eq(aes(label =
    paste(after_stat(eq.label),
          after_stat(p.value.label),
          sep = "*\", \"*")),
          method = "SMA")

# using ranged major axis regression
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(method = "RMA", range.y = "interval", range.x = "interval") +
  stat_ma_eq(aes(label =
    paste(after_stat(eq.label),
          after_stat(p.value.label),
          sep = "*\", \"*")),
          method = "RMA",
          range.y = "interval", range.x = "interval")

# No permutation-based test
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(method = "MA") +
  stat_ma_eq(aes(label =
    paste(after_stat(eq.label),
          after_stat(p.value.label),
          sep = "*\", \"*")),
          method = "MA", nperm = 0)

# explicit formula "x explained by y"
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(formula = x ~ y) +
  stat_ma_eq(formula = x ~ y,
             aes(label = paste(after_stat(eq.label),
                               after_stat(p.value.label),
                               sep = "*\", \"*")))

# grouping
ggplot(my.data, aes(x, y, color = group)) +
  geom_point() +
  stat_ma_line() +
  stat_ma_eq()

# labelling equations
ggplot(my.data, aes(x, y,  shape = group, linetype = group,
       grp.label = group)) +
  geom_point() +
  stat_ma_line(color = "black") +
  stat_ma_eq(aes(label = paste(after_stat(grp.label),
                               after_stat(eq.label),
                               sep = "*\": \"*"))) +
  theme_classic()

# geom = "text"
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line() +
  stat_ma_eq(label.x = "left", label.y = "top")

# Inspecting the returned data using geom_debug()
\dontrun{
if (requireNamespace("gginnards", quietly = TRUE)) {
  library(gginnards)

# This provides a quick way of finding out the names of the variables that
# are available for mapping to aesthetics.

# default is output.type = "expression"
  ggplot(my.data, aes(x, y)) +
    geom_point() +
    stat_ma_eq(geom = "debug")

  ggplot(my.data, aes(x, y)) +
    geom_point() +
    stat_ma_eq(aes(label = after_stat(eq.label)),
               geom = "debug",
               output.type = "markdown")

  ggplot(my.data, aes(x, y)) +
    geom_point() +
    stat_ma_eq(geom = "debug", output.type = "text")

  ggplot(my.data, aes(x, y)) +
    geom_point() +
    stat_ma_eq(geom = "debug", output.type = "numeric")

}
}

}
\seealso{
This \code{stat_ma_eq} statistic can return ready formatted labels
  depending on the argument passed to \code{output.type}. If other than
  linear major axis regression is desired, then \code{\link{stat_poly_eq}} or
  \code{\link{stat_quant_eq}} should be used instead of \code{stat_ma_eq}.
  For other types of models such as non-linear models, statistics
  \code{\link{stat_fit_glance}} and \code{\link{stat_fit_tidy}} should be
  used and the code for construction of character strings from numeric values
  and their mapping to aesthetic \code{label} needs to be explicitly supplied
  in the call.

Other ggplot statistics for major axis regression: 
\code{\link{stat_ma_line}()}
}
\concept{ggplot statistics for major axis regression}
