% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-quadrant-counts.R
\name{stat_quadrant_counts}
\alias{stat_quadrant_counts}
\title{Number of observations in quadrants}
\usage{
stat_quadrant_counts(mapping = NULL, data = NULL, geom = "text",
  position = "identity", quadrants = NULL, pool.along = "none",
  origin.x = 0, origin.y = 0, labels.range.x = NULL,
  labels.range.y = NULL, na.rm = FALSE, show.legend = FALSE,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{quadrants}{integer vector indicating which quadrants are of interest,
with a \code{OL} indicating the whole plot.}

\item{pool.along}{character, one of "none", "x" or "y", indicating which
quadrants to pool to calculate counts by pair of quadrants.}

\item{origin.x, origin.y}{numeric the coordinates of the origin of the
quadrants.}

\item{labels.range.x, labels.range.y}{\code{numeric} Coordinates (in data
units) to be used for absolute positioning of the labels.}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and should not inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
\code{stat_quadrant_counts()} counts the number of observations in each quadrant
of a plot panel. By default it adds a text label to the far corner of each
quadrant. It can also be used to obtain the total number of observations in
each of two pairs of quadrants or in the whole panel. Grouping is ignored, so
en every case a single count is computed for each quadrant in a plot panel.
}
\details{
This stat can be used to automatically count observations in each of
  the four quadrants of a plot, and by default add these counts as text
  labels.
}
\note{
Values exactly equal to zero are counted as belonging to the positve
  quadrant. An argument value of zero, passed to formal parameter
  \code{quadrants} is interpreted as a request for the count of all
  observations in each plot panel. By default, which quadrants to compute
  counts for is decided based on which quadrants are expected to be visible in
  the plot. In the current implementation, the default positions of the
  labels is based on the range of the data ploted in a given panel.
  Consequently, when using facets unless using free limits for x and y axes,
  the location of the labels will need supplied by the user when consistent
  placement accross panels is desired.
}
\section{Computed variables}{
 Data frame with one to four rows, one for each
  quadrant for which observations are present in \code{data}. \describe{
  \item{quadrant}{integer, one of 0:4} \item{x}{extreme x value in the
  quadrant} \item{y}{extreme y value in the quadrant} \item{count}{number of
  observations} }
}

\examples{
library(ggplot2)
# generate artificial data
set.seed(4321)
x <- 1:100
y <- rnorm(length(x), mean = 10)
my.data <- data.frame(x, y)

ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_quadrant_counts()

ggplot(my.data, aes(x - 50, y - 10)) +
  geom_hline(yintercept = 0, colour = "blue") +
  geom_vline(xintercept = 0, colour = "blue") +
  geom_point() +
  stat_quadrant_counts(colour = "blue")

ggplot(my.data, aes(x - 50, y - 10)) +
  geom_hline(yintercept = 0, colour = "blue") +
  geom_point() +
  stat_quadrant_counts(colour = "blue", pool.along = "x")

ggplot(my.data, aes(x - 50, y - 10)) +
  geom_vline(xintercept = 0, colour = "blue") +
  geom_point() +
  stat_quadrant_counts(colour = "blue", pool.along = "y")

ggplot(my.data, aes(x - 50, y - 10)) +
  geom_point() +
  stat_quadrant_counts(quadrants = 0)

}
