% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motifLocation.R
\name{motifLocation}
\alias{motifLocation}
\title{Extract and Visualize Motif Information from MEME Software}
\arguments{
\item{data}{A data frame file from getMotifFromXML function.}

\item{tree.path}{A file path of the correponding phylogenetic tree.
The IDs of the phylogenetic tree must be same as the IDs of sequences used to identify motifs using MEME.}
}
\value{
Return a plot
}
\description{
\code{motifLocation} Visualize motif location in a specificial sequences..
}
\examples{
# without phylogenetic tree
filepath <- system.file("examples", "meme.xml", package = "ggmotif")
motif_extract <- getMotifFromMEME(data = filepath, format="xml")
motif_plot <- motifLocation(data = motif_extract)

# with phylogenetic tree
filepath <- system.file("examples", "meme.xml", package = "ggmotif")
treepath <- system.file("examples", "ara.nwk", package="ggmotif")
motif_extract <- getMotifFromMEME(data = filepath, format="xml")
motif_plot <- motifLocation(data = motif_extract, tree = treepath)

}
\author{
Xiang LI <lixiang117423@foxmail.com>
}
