% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggs_pairs.R
\name{ggs_pairs}
\alias{ggs_pairs}
\title{Create a plot matrix of posterior simulations}
\usage{
ggs_pairs(D, family = NA, greek = FALSE, ...)
}
\arguments{
\item{D}{Data frame with the simulations.}

\item{family}{Name of the family of parameters to plot, as given by a character vector or a regular expression. A family of parameters is considered to be any group of parameters with the same name but different numerical value between square brackets (as beta[1], beta[2], etc).}

\item{greek}{Logical value indicating whether parameter labels have to be parsed to get Greek letters. Defaults to false.}

\item{...}{Arguments to be passed to \code{ggpairs}, including geom's \code{aes} (see examples)}
}
\value{
A \code{ggpairs} object that creates a plot matrix consisting of univariate density plots on the diagonal, correlation estimates in upper triangular elements, and scatterplots in lower triangular elements.
}
\description{
Pairs style plots to evaluate posterior correlations among parameters.
}
\examples{
\dontrun{
library(GGally)
data(linear)

# default ggpairs plot
ggs_pairs(ggs(s))

# change alpha transparency of points
ggs_pairs(ggs(s), lower=list(continuous = wrap("points", alpha = 0.2)))

# with too many points, try contours instead
ggs_pairs(ggs(s), lower=list(continuous="density"))

# histograms instead of univariate densities on diagonal
ggs_pairs(ggs(s), diag=list(continuous="barDiag"))

# coloring results according to chains
ggs_pairs(ggs(s), mapping = aes(color = Chain))

# custom points on lower panels, black contours on upper panels
ggs_pairs(ggs(s),
  upper=list(continuous = wrap("density", color = "black")),
  lower=list(continuous = wrap("points", alpha = 0.2, shape = 1)))
}
}
\references{
Fernández-i-Marín, Xavier (2016) ggmcmc: Analysis of MCMC Samples and Bayesian Inference. Journal of Statistical Software, 70(9), 1-20. doi:10.18637/jss.v070.i09
}

