% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggHeatmap.R
\name{ggHeatmap}
\alias{ggHeatmap}
\title{Make an interactive Heatmap}
\usage{
ggHeatmap(data, mapping, stat = "count", gradient_colors = c("white",
  "steelblue"), addlabel = FALSE, polar = FALSE, interactive = FALSE,
  yangle = 0, color = "black", size = 0.1, ...)
}
\arguments{
\item{data}{A data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{stat}{The statistical transformation to use on the data for this layer, as a string
c("count","identity")}

\item{gradient_colors}{A voector of color names used in function scale_fill_gradientn().
Default value is c("white","steelblue")}

\item{addlabel}{A logical value. If TRUE, label will be added to the plot}

\item{polar}{A logical value. If TRUE, coord_polar() function will be added}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}

\item{yangle}{A integer. The value will be used adjust the angle of axis.text.y}

\item{color}{Color argument passed on to geom_bar_interactive.}

\item{size}{Size argument passed on to geom_bar_interactive.}

\item{...}{other arguments passed on to geom_bar_interactive.}
}
\value{
An interactive barplot
}
\description{
Make an interactive Heatmap
}
\examples{
require(moonBook)
require(ggplot2)
require(ggiraph)
ggHeatmap(acs,aes(x=Dx,y=smoking),addlabel=TRUE)
ggHeatmap(rose,aes(x=Month,y=group,fill=value),stat="identity",gradient_colors = c("white","red"))
ggHeatmap(taco,aes(x=AgeGroup,y=Filling,fill=Rating,facet=ShellType),stat="identity")
}

