% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggBoxplot.R
\name{ggBoxplot}
\alias{ggBoxplot}
\title{Draw boxplots of a data.frame}
\usage{
ggBoxplot(data, mapping = NULL, rescale = FALSE, horizontal = FALSE,
  interactive = FALSE, ...)
}
\arguments{
\item{data}{a data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{rescale}{if true, rescale the data.frame}

\item{horizontal}{if true, horizontal boxplots will be made}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}

\item{...}{other arguments passed on to geom_boxplot_interactive}
}
\description{
Draw boxplots of a data.frame
}
\examples{
require(ggplot2)
require(ggiraph)
require(reshape2)
ggBoxplot(mtcars,rescale=TRUE)
ggBoxplot(mtcars,aes(x=c(mpg,cyl,disp,hp,drat),color=am),rescale=TRUE)
ggBoxplot(mtcars,rescale=TRUE,interactive=TRUE)
ggBoxplot(mtcars,horizontal=TRUE,interactive=TRUE)
}

