% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-debug.R
\name{geom_debug}
\alias{geom_debug}
\alias{geom_debug_npc}
\title{Geom that prints input data to console.}
\usage{
geom_debug(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  summary.fun = "head",
  summary.fun.args = list(),
  parse = NULL,
  nudge_x = 0,
  nudge_y = 0,
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)

geom_debug_npc(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  summary.fun = "head",
  summary.fun.args = list(),
  parse = NULL,
  nudge_x = 0,
  nudge_y = 0,
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by
\code{\link[ggplot2]{aes}} or \code{\link{aes_}}. If specified and
\code{inherit.aes = TRUE} (the default), is combined with the default
mapping at the top level of the plot. You only need to supply
\code{mapping} if there isn't a mapping defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{summary.fun}{The name of a function as a character string (or a
function) to be used to summarize the \code{data} object received as input
before printing it.}

\item{summary.fun.args}{A list of additional arguments
to be passed to \code{summary.fun}.}

\item{parse}{Ignored. Helps avoid warnings.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustments to nudge the
starting position. The units for \code{nudge_x} and \code{nudge_y} are the
same as for the data units on the x-axis and y-axis.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There
  are three types of arguments you can use here:

  \itemize{ \item Aesthetics: to set an aesthetic to a fixed value, like
  \code{color = "red"} or \code{size = 3}. \item Other arguments to the
  layer, for example you override the default \code{stat} associated with the
  layer. \item Other arguments passed on to the stat. }}
}
\value{
The panel function of this geometry always returns a
  \code{\link[grid]{nullGrob}}, the legend is is also set to
  \code{\link[grid]{nullGrob}}. This geometry used for its text printing side
  effect.
}
\description{
The debug geom is used to print to the console a summary of the data being
received by geoms as input \code{data} data frame.
}
\details{
It can be useful when debugging the code of statistics or to learn how the
stats and geoms work in 'ggplot2' (>= 2.0.0).

The intended use of this geometry is to help explore the data as
  they are added to a plot layer. It is very unusual in that it does not
  produce visible graphic output. It only returns a \code{grid.null()} grob
  (graphical object) when the plot is rendered. Also, differently to normal
  geometries, it passes its \code{data} input as argument to the first
  parameter of the function passed as argument to \code{summary.fun}. The
  value returned by this function is then printed to the R console. If
  \code{summary.fun = NULL}, the whole \code{data} object is printed.

  Nudging with \code{nudge_x} and \code{nudge_y} behave as in
  \code{\link[ggplot2]{geom_text}}. Arguments passed to \code{position} are
  obeyed. So the effects of positions are reflected in the \code{data} object
  printed or summarized to the R console. The argument passed to \code{parse}
  is currently ignored.

  Many aesthetics are defined as optional so that they are accepted silently
  by \code{geom_debug()} and handled by 'ggplot2' as usual.

  If the argument passed to \code{summary.fun()} is a character string, the
  name will appear in the header of the printout. However, the function
  must be available at the time the plot is rendered. If a function is
  passed as argument, its definition will be saved as part of the \code{"gg"}
  object.
}
\examples{
# echo to the R console \code{data} as received by geoms
ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug()

ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug(summary.fun = "head", summary.fun.args = list(n = 3))

ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug(summary.fun = "nrow")

ggplot(mtcars, aes(cyl, mpg, color = factor(cyl))) +
  geom_point() +
  geom_debug(summary.fun = "attributes")

# echo to the R console \code{data} as received by geoms
ggplot(mtcars, aes(cyl, mpg, colour = factor(cyl))) +
  stat_summary(fun.data = "mean_se") +
  stat_summary(fun.data = "mean_se", geom = "debug", summary.fun = NULL)

# shape data is not passed to geometries or statistics
if (requireNamespace("sf", quietly = TRUE)) {
  nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

  ggplot(data = nc) +
    geom_sf(color = "darkblue", fill = "white") +
    geom_debug()
}

}
\seealso{
To access data, scales and grobs in a built ggplot, see
  \code{\link[ggplot2]{ggplot_build}}.
}
