% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_hourglass.R
\docType{data}
\name{StatHourglass}
\alias{StatHourglass}
\alias{stat_hourglass}
\title{A ggplot2 \code{stat} function to wrangle data for \code{geom_hourglass}.}
\format{
An object of class \code{StatHourglass} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 7.
}
\usage{
StatHourglass

stat_hourglass(
  mapping = NULL,
  data = NULL,
  geom = "hourglass",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  hour_center = 0,
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}. If
specified and \code{inherit.aes = TRUE} (the default), it is combined with the
default mapping at the top level of the plot. You must supply mapping if
there is no plot mapping. The \code{hourglass} \code{stat} and \code{geom} requires either
the \code{x} axis or the \code{y} axis to be mapped. The mapped aesthetic will show
the date of the variable, whereas the opposite axis will show the time of day.}

\item{data}{The data to be displayed in this layer. If \code{NULL}, the default,
the data is inherited from the plot data as specified in the call to
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}. Otherwise, a \code{data.frame}, or other object, will override
the plot data. All objects will be fortified to produce a data frame.
See \code{\link[ggplot2:fortify]{ggplot2::fortify()}} for which variables will be created. The data should
contain a column with datetime values (e.g., \code{?POSIXct})}

\item{geom}{Can be used to overwrite the default connection between \code{stat_hourglass}
and \verb{[geom_hourglass]}.}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{hour_center}{The hour at which the time of day is centred. Default is 0,
meaning midnight. -12 centres around noon of the preceding day, +12 centres
around noon of the next day.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning.
If \code{TRUE}, missing values are silently removed.}

\item{...}{Arguments passed as extra \code{param}s to \code{\link[ggplot2:layer]{ggplot2::layer()}}}
}
\value{
Returns a \code{\link[ggplot2:layer]{ggplot2::layer()}} which can be added to a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
\description{
Splits mapped \code{x} or \code{y} aesthetic from a continuous datetime into
discrete date values on the mapped axis. The hour of day is mapped to
the opposite axis.
}
\examples{
stat_hourglass()
}
\author{
Pepijn de Vries
}
\keyword{datasets}
