% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_seqs.R
\name{read_seq_len}
\alias{read_seq_len}
\alias{read_fai}
\title{Read sequence index}
\usage{
read_seq_len(file)

read_fai(file, col_names = def_names("fai"), col_types = def_types("fai"), ...)
}
\arguments{
\item{file}{with sequence length information}

\item{col_names}{Either \code{TRUE}, \code{FALSE} or a character vector
of column names.

If \code{TRUE}, the first row of the input will be used as the column
names, and will not be included in the data frame. If \code{FALSE}, column
names will be generated automatically: X1, X2, X3 etc.

If \code{col_names} is a character vector, the values will be used as the
names of the columns, and the first row of the input will be read into
the first row of the output data frame.

Missing (\code{NA}) column names will generate a warning, and be filled
in with dummy names \code{...1}, \code{...2} etc. Duplicate column names
will generate a warning and be made unique, see \code{name_repair} to control
how this is done.}

\item{col_types}{One of \code{NULL}, a \code{\link[readr:cols]{cols()}} specification, or
a string. See \code{vignette("readr")} for more details.

If \code{NULL}, all column types will be inferred from \code{guess_max} rows of the
input, interspersed throughout the file. This is convenient (and fast),
but not robust. If the guessed types are wrong, you'll need to increase
\code{guess_max} or supply the correct types yourself.

Column specifications created by \code{\link[=list]{list()}} or \code{\link[readr:cols]{cols()}} must contain
one column specification for each column. If you only want to read a
subset of the columns, use \code{\link[readr:cols_only]{cols_only()}}.

Alternatively, you can use a compact string representation where each
character represents one column:
\itemize{
\item c = character
\item i = integer
\item n = number
\item d = double
\item l = logical
\item f = factor
\item D = date
\item T = date time
\item t = time
\item ? = guess
\item _ or - = skip
}

By default, reading a file without a column specification will print a
message showing what \code{readr} guessed they were. To remove this message,
set \code{show_col_types = FALSE} or set \code{options(readr.show_col_types = FALSE)}.}

\item{...}{additional parameters, passed to \code{read_tsv}}
}
\value{
tibble with sequence information

tibble with sequence information
}
\description{
Read sequence index
}
\section{Functions}{
\itemize{
\item \code{read_seq_len()}: read seqs from a single file_name in fasta, gbk or gff3 format.

\item \code{read_fai()}: read seqs from a single file in seqkit/samtools fai format.

}}
