% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peel.r
\name{peel_hulls}
\alias{peel_hulls}
\title{Bivariate data peelings}
\usage{
peel_hulls(
  x,
  y = NULL,
  num = NULL,
  by = 1L,
  breaks = c(0.5),
  cut = c("above", "below")
)
}
\arguments{
\item{x, y}{coordinate vectors of points. This can be specified as two
    vectors \code{x} and \code{y}, a 2-column matrix \code{x}, a list
    \code{x} with two components, etc, see \code{\link[grDevices]{xy.coords}}.}

\item{num}{A positive integer; the number of hulls to peel. Pass \code{Inf} for
all hulls.}

\item{by}{A positive integer; with what frequency to include consecutive
hulls, pairs with \code{num}.}

\item{breaks}{A numeric vector of fractions (between \code{0} and \code{1}) of the data
to contain in each hull; overridden by \code{num}.}

\item{cut}{Character; one of \code{"above"} and \code{"below"}, indicating whether each
hull should contain at least or at most \code{breaks} of the data, respectively.}
}
\value{
A matrix with some or all of the following columns:
\describe{
\item{\code{x},\code{y}}{original coordinates}
\item{\code{i}}{position in input matrix or vectors}
\item{\code{hull}}{index of hull, starting from outermost}
\item{\code{frac}}{value of \code{breaks} used to determine hull}
\item{\code{prop}}{proportion of data within hull}
}
}
\description{
Use convex hulls (and eventually other peelings) to order
bivariate data.
}
\details{
Methods for peeling bivariate data into concentric tiers generalize
the univariate concept of rank to separate core versus peripheral cases
(Green, 1981).

The code for peeling convex hulls was adapted from \code{plothulls()} in the
\strong{\href{https://cran.r-project.org/package=aplpack}{aplpack}} package.
Other peeling options should be implemented soon.
}
\examples{
x <- mtcars$disp; y <- mtcars$mpg

# all hulls
peel_hulls(x, y, num = Inf)

# every third hull
peel_hulls(x, y, num = Inf, by = 3)

# tertile hulls, cut below
peel_hulls(x, y, breaks = seq(0, 1, length.out = 4))

# tertile hulls, cut above
peel_hulls(x, y, breaks = seq(0, 1, length.out = 4), cut = "below")
}
\references{
Green PJ (1981) "Peeling Bivariate Data". \emph{Interpreting Multivariate Data}
Chapter 1, 3--19. John Wiley & Sons, Ltd, ISBN 978-0-471-28039-2.
}
