% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-bagplot.r
\name{geom_bagplot}
\alias{geom_bagplot}
\title{Bagplots}
\usage{
geom_bagplot(
  mapping = NULL,
  data = NULL,
  stat = "bagplot",
  position = "identity",
  ...,
  bag.linewidth = sync(),
  bag.linetype = sync(),
  bag.colour = "black",
  bag.color = NULL,
  bag.fill = sync(),
  bag.alpha = NA,
  median.shape = 21L,
  median.stroke = sync(),
  median.size = 5,
  median.colour = sync(),
  median.color = NULL,
  median.fill = "white",
  median.alpha = NA,
  fence.linewidth = 0.25,
  fence.linetype = 0L,
  fence.colour = sync(),
  fence.color = NULL,
  fence.fill = sync(),
  fence.alpha = 0.25,
  outlier.shape = sync(),
  outlier.stroke = sync(),
  outlier.size = sync(),
  outlier.colour = sync(),
  outlier.color = NULL,
  outlier.fill = NA,
  outlier.alpha = NA,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{bag.linetype, bag.linewidth, bag.colour, bag.color, bag.fill, bag.alpha}{Default aesthetics for bags. Set to \code{\link[=sync]{sync()}} to inherit from the data's
aesthetics or to \code{NULL} to use the data's aesthetics.}

\item{median.shape, median.stroke, median.size, median.colour, median.color, median.fill, median.alpha}{Default aesthetics for medians. Set to \code{\link[=sync]{sync()}} to inherit from the data's
aesthetics or to \code{NULL} to use the data's aesthetics.}

\item{fence.linetype, fence.linewidth, fence.colour, fence.color, fence.fill, fence.alpha}{Default aesthetics for fences. Set to \code{\link[=sync]{sync()}} to inherit from the data's
aesthetics or to \code{NULL} to use the data's aesthetics.}

\item{outlier.shape, outlier.stroke, outlier.size, outlier.colour, outlier.color, outlier.fill, outlier.alpha}{Default aesthetics for outliers. Set to \code{\link[=sync]{sync()}} to inherit from the data's
aesthetics or to \code{NULL} to use the data's aesthetics.}

\item{na.rm}{Passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \link[=gggda-ggproto]{ggproto} \link[ggplot2:layer]{layer}.
}
\description{
Render bagplots from tagged data comprising medians, hulls,
contours, and outlier specifications.
}
\details{
\code{geom_bagplot()} is designed to pair with \code{\link[=stat_bagplot]{stat_bagplot()}},
analogously to the pairing of \code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}} with
\code{\link[ggplot2:geom_boxplot]{ggplot2::stat_boxplot()}}.

Because the optional components are more expensive to compute in this
setting, they are controlled by parameters passed to the stat. Auxiliary
aesthetics like \code{median.colour} are available that override auxiliary
defaults, and these in turn override the standard defaults. Auxiliary
defaults also take effect when auxiliary aesthetics are passed \code{NULL}, so
that \code{stat_bagplot()} and \code{geom_bagplot()} have the same default behavior.
Pass \code{sync()} (instead of \code{NULL}, as in \code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}}) to
synchronize an auxiliary aesthetic with its standard counterpart.

\strong{WARNING:}
The trade-off between precision and runtime is greater for depth estimation
than for density estimation. At the resolution of the default \eqn{100
  \times 100} grid, basic examples may vary noticeably when starting from
different random seeds.
}
\section{Aesthetics}{

\code{geom_bagplot()} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \strong{\code{component}}
\item \code{linewidth}
\item \code{linetype}
\item \code{colour}
\item \code{fill}
\item \code{alpha}
\item \code{shape}
\item \code{stroke}
\item \code{size}
\item \code{group}
}
}

\examples{
# Motor Trends base plot with factorized cylinder counts
p <- mtcars \%>\% 
  transform(cyl = factor(cyl)) \%>\% 
  ggplot(aes(x = wt, y = disp)) +
  theme_bw()
# basic bagplot
p + geom_bagplot()
# group by cylinder count
p + geom_bagplot(
  fraction = 0.4, coef = 1.2,
  aes(fill = cyl, linetype = cyl, color = cyl)
)
# using normally unmapped aesthetics
p + geom_bagplot(
  fraction = 0.4, coef = 1.2,
  aes(fill = cyl, linetype = cyl, color = cyl),
  median.color = "black",
  fence.linetype = sync(), fence.colour = "black",
  outlier.shape = "asterisk", outlier.colour = "black"
)
}
\seealso{
Other geom layers: 
\code{\link{geom_axis}()},
\code{\link{geom_isoline}()},
\code{\link{geom_lineranges}()},
\code{\link{geom_rule}()},
\code{\link{geom_text_radiate}()},
\code{\link{geom_vector}()}
}
\concept{geom layers}
