% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_no_axes}
\alias{theme_no_axes}
\title{Theme without axes and gridlines}
\usage{
theme_no_axes(base.theme = theme_bw())
}
\arguments{
\item{base.theme}{The theme to use as a base for the new theme. Defaults to
\code{\link[ggplot2]{theme_bw}()}.}
}
\value{
A modified version of base.theme
}
\description{
This theme is a simple wrapper around any complete theme that removes the
axis text, title and ticks as well as the grid lines for plots where these
have little meaning.
}
\examples{
p <- ggplot() + geom_point(aes(x = wt, y = qsec), data = mtcars)

p + theme_no_axes()
p + theme_no_axes(theme_grey())

}
