% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_data_analysis.R
\name{ggi}
\alias{ggi}
\title{Pass a MCA plot into a html interactive plot}
\usage{
ggi(
  plot = ggplot2::last_plot(),
  width = NULL,
  height = NULL,
  keep_ratio = TRUE,
  savewidget = FALSE,
  dir = NULL,
  name = "Plot",
  replace = FALSE,
  open = rlang::is_interactive(),
  iframe = NULL,
  pixel_width,
  ...
)
}
\arguments{
\item{plot}{The plot, created with \link{ggmca} or \link{ggca}.}

\item{width}{The width in centimeters. Default to printing device's size.}

\item{height}{The height in centimeters. Default to printing device's size.}

\item{keep_ratio}{By default, the height is forced based of the relative
size of the MCA's axes. Set to \code{FALSE} to avoid this behavior.}

\item{savewidget}{Should the html widget be saved on disk ?}

\item{dir}{If saved as file, the directory in which to save the html widget.
Default to temporary directory. Set global option \code{"ggfacto.export_dir"}
with \code{link[base:options](options)} to change default directory.}

\item{name}{The name of the file to save.}

\item{replace}{Replace file ? By default, number added to find a new name.}

\item{open}{Should the resulting file be opened at once ?}

\item{iframe}{Create an html frame around the plot to ensure fixed
dimensions. Useful when opening the plot in a web browser (but will produce a blank
graph with \pkg{rmarkdown}). This is default behavior with \code{savewidget = TRUE}.
Require package \code{\link[widgetframe:widgetframe]{widgetframe}}.}

\item{pixel_width}{The width in pixels for
\code{\link[widgetframe:widgetframe]{widgetframe}}.}

\item{...}{Additional arguments to pass to \code{\link[ggiraph:girafe]{girafe}} and
\code{\link[ggiraph:dsvg]{dsvg}}. \code{fonts} can be used to provide text fonts.}
}
\value{
An html plot.
}
\description{
Pass a MCA plot into a html interactive plot
}
