% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_data_analysis.R
\name{PCA2}
\alias{PCA2}
\title{Principal Component Analysis}
\usage{
PCA2(
  data,
  active_vars,
  wt,
  col.w = NULL,
  ind_name,
  scale.unit = TRUE,
  ind.sup = NULL,
  ncp = 5,
  graph = FALSE,
  ...
)
}
\arguments{
\item{data}{The data frame.}

\item{active_vars}{<\link[tidyr:tidyr_tidy_select]{tidy-select}> The names
of the active variables.}

\item{wt}{The name of the row weight variable}

\item{col.w}{The weights of the columns, as a numeric vector of the same
length than `active_vars.`}

\item{ind_name}{Possibly, a variable with the names of the individuals.}

\item{scale.unit}{A boolean, if `TRUE` (value set by default) then data are
scaled to unit variance.}

\item{ind.sup}{A vector indicating the indexes of the supplementary individuals.}

\item{ncp}{Number of dimensions kept in the results (by default 5).}

\item{graph}{A boolean, set to `TRUE` to display the base graph.}

\item{...}{Additional arguments to pass to \code{\link[FactoMineR]{PCA}}.}
}
\value{
A `res.pca` object, with all the data necessary to draw the PCA.
}
\description{
A user-friendly wrapper around \code{\link[FactoMineR]{PCA}}, made to
 work better with \pkg{ggfacto} functions like \code{\link{ggpca_cor_circle}}.
 All variables can be selected by many different expressions, in the way of
 the `tidyverse`. No supplementary vars are to be provided here,
 since they can be added afterward.
}
\examples{
active_vars <- c("mpg", "cyl", "hp", "drat", "qsec")
res.pca <- PCA2(mtcars, tidyselect::all_of(active_vars) )

}
