% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-bar-tile-etho.R, R/stat-tile-etho.R
\name{stat_bar_tile_etho}
\alias{stat_bar_tile_etho}
\alias{stat_tile_etho}
\title{Display a variable of interest either as a colour intensity value or as a bar height}
\usage{
stat_bar_tile_etho(mapping = NULL, data = NULL, geom = "bar_tile",
  position = "identity", ..., method = mean, method.args = list(),
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE)

stat_tile_etho(mapping = NULL, data = NULL, geom = "raster",
  position = "identity", ..., method = mean, method.args = list(),
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{method}{function used to compute the aggregate, when/if grouping several individuals on the same row.
The default is fucntion is \link{mean}. \link{median}, \link{min}, \link{max} are examples of alternatives.}

\item{method.args}{List of additional arguments passed on to the modelling
function defined by \code{method}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}
}
\value{
A ggplot layer.
\itemize{
\item The relevant \href{https://rethomics.github.io/ggetho.html#tile-plots}{rethomic tutorial section}
}
}
\description{
These functions show the temporal trend (time on the x axis) of a variable of interest (z axis)
as either colour intensity (\code{stat_tile_etho}) or using the hight of the tiles (\code{stat_bar_tile_etho}).
In both cases, the y axis is a discrete variable such as a treatment or the id of individuals.
}
\examples{
# We start by making a to dataset with 20 animals
metadata <- data.frame(id = sprintf("toy_experiment | \%02d", 1:20),
                   age = c(1, 5, 10, 20),
                   condition = c("A", "B"))
print(metadata)
dt <- toy_activity_data(metadata, 3)
# We build a plot object
pl <-  ggetho(dt, aes(z = asleep))
# A standard plot one row per animal:
pl + stat_tile_etho()
# We can also group animals per condition and calculate the average sleep
pl <-  ggetho(dt, aes(z = asleep, y = condition))
pl + stat_tile_etho()

# We can sort by adding condition AND id on the y axis:
pl <-  ggetho(dt, aes(z = asleep, y = interaction(id, condition)))
pl + stat_tile_etho()
# Same if we want to sort by age
pl <-  ggetho(dt, aes(z = asleep, y = interaction(id, age)))
pl + stat_tile_etho()

# Instead, of the average, maybe we want to show the highest (max)
# posible value of sleep for any time point
pl + stat_tile_etho(method = max)
# We can also use stat_bar_tile as an alternative
pl + stat_bar_tile_etho()
}
\seealso{
\itemize{
\item \link{ggetho} to generate a plot object
\item \link{stat_pop_etho} to show population trend by aggregating individuals over time
\item \link{stat_ld_annotations} to show light and dark phases on the plot
}

Other layers: \code{\link{geom_peak}},
  \code{\link{stat_ld_annotations}},
  \code{\link{stat_pop_etho}}
}
\concept{layers}
