% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdmc_plotting.R
\name{plot.hyper}
\alias{plot.hyper}
\title{Plot DMC Samples at the Hyper level}
\usage{
\method{plot}{hyper}(x, y = NULL, hyper = FALSE, start = 1, end = NA,
  save.ll = FALSE, main.pll = NULL, pll.chain = FALSE,
  pll.together = TRUE, pll.barplot = FALSE, only.prior = FALSE,
  only.like = FALSE, subject = 1, smooth = FALSE, density = FALSE,
  save.dat = FALSE, p.prior = NULL, natural = TRUE, trans = NA,
  xlim = NA, chain1 = TRUE, ...)
}
\arguments{
\item{x}{\code{run.dmc} or \code{samples.dmc} generated model samples}

\item{y}{default NULL. No function. Just to make it compatible to
\code{plot}}

\item{hyper}{a boolean switch to draw hyper-parameter. By default it is off.}

\item{start}{instruct the function to plot starting from which iteration.
This indicates how many burn-in interations one requests. For example,
start=101, indicates 100 burn-in interations.}

\item{end}{instruct the function to plot ending at a certain iteration}

\item{save.ll}{a boolean switch to tell the function to save the mean
log-likelihood. This option does not work in DMC's plot.dmc, too.}

\item{main.pll}{a string as the title for the boxplot. Default is NULL}

\item{pll.chain}{a boolean switch to plot posterior log likelihoood}

\item{pll.together}{a boolean switch to plot the posterior log-likelihood
chains all together in one canvar}

\item{pll.barplot}{a boolean switch to plot the means of posterior
log-likelihood of all chains as a barplot. By default, it is off.}

\item{only.prior}{only.prior and only.like pick out one or other
component of pll.}

\item{only.like}{a boolean switch.}

\item{subject}{indicate which subject to plot in a multi-subject list
samples}

\item{smooth}{default FALSE}

\item{density}{plot probability density too?}

\item{save.dat}{whether save the internal data table out for polish plots}

\item{p.prior}{prior distribution setting. necessary for plot.prior to work}

\item{natural}{additional argument for plot.prior}

\item{trans}{additional argument for plot.prior}

\item{xlim}{additional argument for plot.prior}

\item{chain1}{plot all chains or just chain1 as coda does}

\item{...}{other arguments}
}
\description{
Plot trace and probability desntiy. This method provides a switch to choose
plotting at the data or hyper level. The samples must be an object fit by
a hierarchical model.
}
\examples{
m1 <- model.dmc(
p.map     = list(a="1",v="1",z="1",d="1",sz="1",sv="1",t0="1",st0="1"),
match.map = list(M=list(s1="r1", s2="r2")),
factors   = list(S=c("s1", "s2")),
constants = c(st0=0, d=0),
responses = c("r1","r2"),
type      = "rd")

## Population distribution
pop.prior <- prior.p.dmc(
  dists = rep("tnorm", 6),
  p1    = c(a=2,   v=2.5, z=0.5, sz=0.3, sv=1,  t0=0.3),
  p2    = c(a=0.5, v=.5,  z=0.1, sz=0.1, sv=.3, t0=0.05),
  lower = c(0,-5, 0, 0, 0, 0),
  upper = c(5, 7, 2, 2, 2, 2))

dat <- h.simulate.dmc(m1, p.prior=pop.prior, n=50, ns=4)
mdi <- data.model.dmc(dat, m1)
p.prior  <- prior.p.dmc(
  dists = rep("tnorm", 6),
  p1    = c(a=2,   v=2.5, z=0.5, sz=0.3, sv=1,  t0=0.3),
  p2    = c(a=0.5, v=.5,  z=0.1, sz=0.1, sv=.3, t0=0.05) * 5,
  lower = c(0,-5, 0, 0, 0, 0),
  upper = c(5, 7, 2, 2, 2, 2))

## Fixed-effect model
samplesInit <- h.samples.dmc(nmc=100, p.prior=p.prior, data=mdi, thin=1)
samples0    <- h.run.dmc(samples=samplesInit, report=20)

## Make a hyper-prior list
mu.prior <- prior.p.dmc(
  dists = rep("tnorm", 6),
  p1    = c(a=2,   v=2.5, z=0.5, sz=0.3, sv=1,  t0=0.3),
  p2    = c(a=0.5, v=.5,  z=0.1, sz=0.1, sv=.3, t0=0.05) * 5,
  lower = c(0,-5, 0, 0, 0, 0),
  upper = c(5, 7, 2, 2, 2, 2))

sigma.prior <- prior.p.dmc(
  dists = rep("beta", 6),
  p1    = c(a=1, v=1, z=1, sz=1, sv=1, t0=1),
  p2    = c(1,1,1,1,1,1),
  upper = c(2,2,2,2,2,2))

pp.prior <- list(mu.prior, sigma.prior)

## Random-effect model
hsamplesInit <- h.samples.dmc(nmc=50, p.prior=p.prior, pp.prior=pp.prior,
  data=mdi, thin=1)
hsamples0 <- h.run.dmc(samples=hsamplesInit)

## Windows Testing errors
## plot(hsamples0) ## Only first participant
## plot(hsamples0, hyper=TRUE) ## Group-level parameters
## plot(hsamples0, hyper=TRUE, density=TRUE) ## Trace and density plots

## plot(hsamples0, p.prior=p.prior) ## plot prior and posterior
## plot(hsamples0, p.prior=pp.prior, hyper=TRUE) ## hyper-level

## plot(hsamples0, hyper=TRUE, start=101) ## starting from 101th iteration
## plot(hsamples0, hyper=TRUE, density=TRUE, start=101)

## Plot posterior likelihood
## plot(hsamples0, hyper=TRUE, pll.chain=TRUE, start=21)

## Save plot data for modifying
## D <- plot(hsamples0, hyper=TRUE, save.dat=TRUE)
## head(D)
## Source: local data frame [6 x 4]
##   Iteration  Chain Parameter    value
##       (int) (fctr)    (fctr)    (dbl)
## 1         1      1      a.h1 2.184504
## 2         2      1      a.h1 2.184504
## 3         3      1      a.h1 2.184504
## 4         4      1      a.h1 2.501221
## 5         5      1      a.h1 2.501221
## 6         6      1      a.h1 2.501221
}
\keyword{plot.dmc}

