% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{trim_ends}
\alias{trim_ends}
\title{Trim extreme values at each end of a vector.}
\usage{
trim_ends(x, trim = 0.05, na.rm = TRUE)
}
\arguments{
\item{x}{A \link{numeric} vector}

\item{trim}{Proportion of vector length to trim. Must be between 0 and 1.
E.g., a value 0.05 (default) trims 2.5\% off each end of a sorted vector.}

\item{na.rm}{omit \code{NA} values. May result in different size vector.}
}
\value{
A \link{numeric} vector in the original order of \code{x}, but with trimmed
values as \code{NA} if \code{na.rm=TRUE} or with these values removed if \code{FALSE}
(which will result in a different sized vector from the input).
}
\description{
Trim extreme values at each end of a vector.
}
\examples{
x <- rgamma(10000, 1, 1)
range(x)
length(x)     # <- 10000
sum(is.na(x)) # <- 0

t <- trim_ends(x, trim = 0.1)
range(t)
length(t)     # <- 9000
sum(is.na(t)) # <- 0

t <- trim_ends(x, 0.1, na.rm = FALSE)
range(t, na.rm = TRUE)
length(t)     # <- 10000
sum(is.na(t)) # <- 1000
}
