% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_hist.R
\name{breaks}
\alias{breaks}
\alias{breaks_fixed}
\alias{breaks_Sturges}
\alias{breaks_Scott}
\alias{breaks_FD}
\title{Break (bin) selection algorithms for histograms}
\usage{
breaks_fixed(x, weights = NULL, width = 1)

breaks_Sturges(x, weights = NULL)

breaks_Scott(x, weights = NULL)

breaks_FD(x, weights = NULL, digits = 5)
}
\arguments{
\item{x}{A numeric vector giving a sample.}

\item{weights}{A numeric vector of \code{length(x)} giving sample weights.}

\item{width}{For \code{\link[=breaks_fixed]{breaks_fixed()}}, the desired bin width.}

\item{digits}{Number of significant digits to keep when rounding in the Freedman-Diaconis
algorithm (\code{\link[=breaks_FD]{breaks_FD()}}). For an explanation of this parameter, see the documentation
of the corresponding parameter in \code{\link[grDevices:nclass]{grDevices::nclass.FD()}}.}
}
\value{
Either a single number (giving the number of bins) or a vector
giving the edges between bins.
}
\description{
Methods for determining breaks (bins) in histograms, as used in the \code{breaks}
argument to \code{\link[=density_histogram]{density_histogram()}}.
Supports \link[=automatic-partial-functions]{automatic partial function application}.
}
\details{
These functions take a sample and its weights and return a valuable suitable for
the \code{breaks} argument to \code{\link[=density_histogram]{density_histogram()}} that will determine the histogram
breaks.
\itemize{
\item \code{\link[=breaks_fixed]{breaks_fixed()}} allows you to manually specify a fixed bin width.
\item \code{\link[=breaks_Sturges]{breaks_Sturges()}}, \code{\link[=breaks_Scott]{breaks_Scott()}}, and \code{\link[=breaks_FD]{breaks_FD()}} implement weighted
versions of the corresponding base functions. See \code{\link[=nclass.Sturges]{nclass.Sturges()}},
\code{\link[=nclass.scott]{nclass.scott()}}, and \code{\link[=nclass.FD]{nclass.FD()}}.
}
}
\examples{
library(ggplot2)

set.seed(1234)
x = rnorm(200, 1, 2)

# Let's compare the different break-selection algorithms on this data:
ggplot(data.frame(x), aes(x)) +
  stat_slab(
    aes(y = "fixed at 0.5"),
    density = "histogram",
    breaks = breaks_fixed(width = 0.5),
    outline_bars = TRUE,
    color = "black",
  ) +
  stat_slab(
    aes(y = "Sturges"),
    density = "histogram",
    breaks = "Sturges",
    outline_bars = TRUE,
    color = "black",
  ) +
  stat_slab(
    aes(y = "Scott"),
    density = "histogram",
    breaks = "Scott",
    outline_bars = TRUE,
    color = "black",
  ) +
  stat_slab(
    aes(y = "FD"),
    density = "histogram",
    breaks = "FD",
    outline_bars = TRUE,
    color = "black",
  ) +
  geom_point(aes(y = 0.7), alpha = 0.5)
}
\seealso{
\code{\link[=density_histogram]{density_histogram()}}, \link{align}
}
