% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_arima.R
\name{geom_arima}
\alias{geom_arima}
\title{ARIMA model}
\usage{
geom_arima(mapping = NULL, data = NULL, stat = "arima",
  geom = c("text", "label"), position = "identity", ...,
  method = c("x13", "tramoseats"), spec = NULL, frequency = NULL,
  message = TRUE, x_arima = NULL, y_arima = NULL, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \link[ggplot2:aes]{aes()} or
\link[ggplot2:aes_]{aes_()}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{A \code{data.frame} that contains the data used for the seasonal adjustment. By default,}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{geom}{character. The geometric to use to display the data:
\code{GeomText} (\code{geom = "text"}, the default, see \link[ggplot2:geom_text]{geom_text()}) or
\code{GeomLabel} (\code{geom = "label"}, see \link[ggplot2:geom_label]{geom_label()}).}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \link[ggplot2:layer]{layer()}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}.}

\item{method}{the method used for the seasonal adjustment. \code{"x13"} (by default) for the X-13ARIMA method and \code{"tramoseats"} for TRAMO-SEATS.}

\item{spec}{the specification used for the seasonal adjustment.
See \link[RJDemetra:x13]{x13()} or \link[RJDemetra:tramoseats]{tramoseats()}.}

\item{frequency}{the frequency of the time series. By default (\code{frequency = NULL}),
the frequency is computed automatically.}

\item{message}{a \code{boolean} indicating if a message is printed with the frequency used.}

\item{x_arima, y_arima}{position of the text of the ARIMA model. By default, the first position of the \code{data} is used.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them.}
}
\description{
Function to add directly to the plot the ARIMA model used in the pre-adjustment process of the seasonal adjustment.
}
\details{
With the parameter \code{geom = "text"}, the ARIMA model used in the pre-adjustment process of the seasonal adjustment are directly added to the plot. With \code{geom = "label"} a rectangle is drawn behind the ARIMA model, making it easier to read.
}
\examples{
p_sa_ipi_fr <- ggplot(data = ipi_c_eu_df, mapping = aes(x = date, y = FR)) +
    geom_line() +
    labs(title = "Seasonal adjustment of the French industrial production index",
         x = "time", y = NULL) +
    geom_sa(color = "red", message = FALSE)
         
# To add the ARIMA model
p_sa_ipi_fr + 
    geom_arima(geom = "label",
               x_arima = - Inf, y_arima = -Inf, 
               vjust = -1, hjust = -0.1,
               message = FALSE)          
}
