% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbrain_label.R
\name{ggbrain_label}
\alias{ggbrain_label}
\title{R6 class for adding labels to a ggbrain_panel}
\value{
a \code{ggbrain_label} R6 class containing fields related to ggbrain plot labels
}
\description{
R6 class for adding labels to a ggbrain_panel

R6 class for adding labels to a ggbrain_panel
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{addl_args}}{a named list of additional argument to be passed to geom_text/geom_label at render}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{data}}{a data.frame containing labels to be printed on the panel. Must contain dim1, dim2, and label as columns.
The dim1 and dim2 columns control where the labels will appear on the panel}

\item{\code{image}}{A character string specifying the image to which these labels pertain}

\item{\code{label_column}}{A character string indicating which data.frame column should be used for drawing labels}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ggbrain_label-new}{\code{ggbrain_label$new()}}
\item \href{#method-ggbrain_label-add_to_gg}{\code{ggbrain_label$add_to_gg()}}
\item \href{#method-ggbrain_label-clone}{\code{ggbrain_label$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_label-new"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_label-new}{}}}
\subsection{Method \code{new()}}{
create a new ggbrain_label object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_label$new(
  data = NULL,
  geom = "text",
  image = NULL,
  label_column = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a data.frame containing labels to be printed on the panel. Must contain dim1, dim2, and label as columns.
The dim1 and dim2 columns control where the labels will appear on the panel}

\item{\code{geom}}{The geom type to be plotted. Must be "text" or "label", corresponding to geom_text and geom_label, respectively.}

\item{\code{image}}{A string specifying the image to which these labels pertain}

\item{\code{label_column}}{the column in \code{data} that should be drawn as labels on the plot}

\item{\code{...}}{All other arguments that will be passed directly to geom_text or geom_label such as hjust, size, and color}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_label-add_to_gg"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_label-add_to_gg}{}}}
\subsection{Method \code{add_to_gg()}}{
add this text layer to an existing ggplot object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_label$add_to_gg(base_gg)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_gg}}{the ggplot object to which we add the layer}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ggbrain_label-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ggbrain_label-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ggbrain_label$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
