% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_automap.R
\name{coord_automap}
\alias{coord_automap}
\title{Specify an inset configuration for the whole plot}
\usage{
coord_automap(feature_type = NA, inset = NULL, ...)
}
\arguments{
\item{feature_type}{Type of map feature. See \code{\link[cartographer:feature_types]{feature_types()}} for a list of
registered types. If \code{NA}, the type is guessed based on the values in
\code{feature_names}.}

\item{inset}{Inset configuration; see \code{\link[=configure_inset]{configure_inset()}}.}

\item{...}{Arguments passed to \code{\link[ggmapinset:coord_sf_inset]{ggmapinset::coord_sf_inset()}}}
}
\value{
A ggplot coordinate
}
\description{
This allows a default inset configuration to be provided to avoid having to
repeat it for each layer. Any layer that is inset-aware can use this as the
default configuration if none is specifically provided to that layer. This
coord also expands the axis limits to include the inset area.
}
\examples{
library(ggplot2)
library(cartographer)

ggplot(nc_type_example_2, aes(location = county)) +
  geom_choropleth(aes(colour = type), size = 0.5) +
  geom_sf_label_inset(aes(label = county), stat = "automap_coords", size = 3) +
  coord_automap(feature_type = "sf.nc")
}
