% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-dendrogram.R
\name{align_dendro}
\alias{align_dendro}
\title{Reorder or Group observations based on hierarchical clustering}
\usage{
align_dendro(
  mapping = aes(),
  ...,
  distance = "euclidean",
  method = "complete",
  use_missing = "pairwise.complete.obs",
  reorder_dendrogram = FALSE,
  merge_dendrogram = FALSE,
  reorder_group = FALSE,
  k = NULL,
  h = NULL,
  cutree = NULL,
  plot_dendrogram = TRUE,
  plot_cut_height = NULL,
  root = NULL,
  center = FALSE,
  type = "rectangle",
  size = NULL,
  data = NULL,
  no_axes = NULL,
  active = NULL,
  free_guides = deprecated(),
  free_spaces = deprecated(),
  plot_data = deprecated(),
  theme = deprecated(),
  free_labs = deprecated(),
  set_context = deprecated(),
  order = deprecated(),
  name = deprecated()
)
}
\arguments{
\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> Additional arguments passed to
\code{\link[ggplot2:geom_segment]{geom_segment()}}.}

\item{distance}{A string of distance measure to be used. This must be one of
\code{"euclidean"}, \code{"maximum"}, \code{"manhattan"}, \code{"canberra"}, \code{"binary"} or
\code{"minkowski"}.  Correlation coefficient can be also used, including
\code{"pearson"}, \code{"spearman"} or \code{"kendall"}. In this way, \code{1 - cor} will be used
as the distance. In addition, you can also provide a \code{\link[stats:dist]{dist}}
object directly or a function return a \code{\link[stats:dist]{dist}} object. Use
\code{NULL}, if you don't want to calculate the distance.}

\item{method}{A string of the agglomeration method to be used. This should be
(an unambiguous abbreviation of) one of \code{"ward.D"}, \code{"ward.D2"}, \code{"single"},
\code{"complete"}, \code{"average"} (= UPGMA), \code{"mcquitty"} (= WPGMA), \code{"median"} (=
WPGMC) or \code{"centroid"} (= UPGMC). You can also provide a function which
accepts the calculated distance (or the input matrix if \code{distance} is \code{NULL})
and returns a \code{\link[stats:hclust]{hclust}} object. Alternative, you can supply
an object which can be coerced to \code{\link[stats:hclust]{hclust}}.}

\item{use_missing}{An optional character string giving a method for computing
covariances in the presence of missing values. This must be (an abbreviation
of) one of the strings \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
\code{"na.or.complete"}, or \code{"pairwise.complete.obs"}. Only used when \code{distance}
is a correlation coefficient string.}

\item{reorder_dendrogram}{A single boolean value indicating whether to
reorder the dendrogram based on the means. Alternatively, you can provide a
custom function that accepts an \code{\link[stats:hclust]{hclust}} object and the data
used to generate the tree, returning either an \code{\link[stats:hclust]{hclust}} or
\code{\link[stats:dendrogram]{dendrogram}} object. Default is \code{FALSE}.}

\item{merge_dendrogram}{A single boolean value, indicates whether we should
merge multiple dendrograms, only used when previous groups have been
established. Default: \code{FALSE}.}

\item{reorder_group}{A single boolean value, indicates whether we should do
Hierarchical Clustering between groups, only used when previous groups have
been established. Default: \code{FALSE}.}

\item{k}{An integer scalar indicates the desired number of groups.}

\item{h}{A numeric scalar indicates heights where the tree should be cut.}

\item{cutree}{A function used to cut the \code{\link[stats:hclust]{hclust}} tree. It
should accept four arguments: the \code{\link[stats:hclust]{hclust}} tree object,
\code{distance} (only applicable when \code{method} is a string or a function for
performing hierarchical clustering), k (the number of clusters), and h (the
height at which to cut the tree). By default, \code{\link[stats:cutree]{cutree()}}
is used.}

\item{plot_dendrogram}{A boolean value indicates whether plot the dendrogram
tree.}

\item{plot_cut_height}{A boolean value indicates whether plot the cut height.}

\item{root}{A length one string or numeric indicates the root branch.}

\item{center}{A boolean value. if \code{TRUE}, nodes are plotted centered with
respect to the leaves in the branch. Otherwise (default), plot them in the
middle of all direct child nodes.}

\item{type}{A string indicates the plot type, \code{"rectangle"} or \code{"triangle"}.}

\item{size}{The relative size of the plot, can be specified as a
\code{\link[grid:unit]{unit}}.}

\item{data}{A matrix-like object. By default, it inherits from the layout
\code{matrix}.}

\item{no_axes}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Logical; if \code{TRUE},
removes axes elements for the alignment axis using \code{\link[=theme_no_axes]{theme_no_axes()}}. By
default, will controled by the option-
\code{"ggalign.align_no_axes"}.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}

\item{free_guides}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} Please use
\code{\link[=plot_align]{plot_align()}} function instead.}

\item{free_spaces}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_align]{plot_align()}} function instead.}

\item{plot_data}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_data]{plot_data()}} function instead.}

\item{theme}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_theme]{plot_theme()}} function instead.}

\item{free_labs}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_align]{plot_align()}} function instead.}

\item{set_context}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{active}
argument instead.}

\item{order}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{active} argument
instead.}

\item{name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{active} argument
instead.}
}
\value{
A \code{"AlignDendro"} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function aligns observations within the layout according to a
hierarchical clustering tree, enabling reordering or grouping of elements
based on clustering results.
}
\section{ggplot2 specification}{

\code{align_dendro} initializes a ggplot \code{data} and \code{mapping}.

The internal will always use a default mapping of \code{aes(x = .data$x, y = .data$y)}.

The default ggplot data is the \code{node} coordinates with \code{edge} data attached
in \code{\link[=ggalign_attr]{ggalign}} attribute, in addition, a
\code{\link[ggplot2:geom_segment]{geom_segment}} layer with a data of the \code{edge}
coordinates will be added.

\code{node} and tree segments \code{edge} coordinates contains following columns:
\itemize{
\item \code{index}: the original index in the tree for the current node
\item \code{label}: node label text
\item \code{x} and \code{y}: x-axis and y-axis coordinates for current node or the start
node of the current edge.
\item \code{xend} and \code{yend}: the x-axis and y-axis coordinates of the terminal node
for current edge.
\item \code{branch}: which branch current node or edge is. You can use this column
to color different groups.
\item \code{panel}: which panel current node is, if we split the plot into panel
using \code{\link[ggplot2:facet_grid]{facet_grid}}, this column will show
which panel current node or edge is from. Note: some nodes may
fall outside panel (between two panel), so there are possible
\code{NA} values in this column.
\item \code{.panel}: Similar with \code{panel} column, but always give the correct branch
for usage of the ggplot facet.
\item \code{panel1} and \code{panel2}: The panel1 and panel2 variables have the same
functionality as \code{panel}, but they are specifically for the \code{edge} data
and correspond to both nodes of each edge.
\item \code{leaf}: A logical value indicates whether current node is a leaf.
}
}

\section{Axis Alignment for Observations}{

It is important to note that we consider rows as observations, meaning
\code{vec_size(data)}/\code{NROW(data)} must match the number of observations along the
axis used for alignment (x-axis for a vertical stack layout, y-axis for a
horizontal stack layout).
\itemize{
\item \code{\link[=quad_layout]{quad_layout()}}/\code{\link[=ggheatmap]{ggheatmap()}}: For column annotation, the layout
\code{matrix} will be transposed before use (if \code{data} is a function, it is
applied to the transposed matrix), as column annotation uses columns as
observations but alignment requires rows.
\item \code{\link[=stack_layout]{stack_layout()}}: The layout matrix is used as is, aligning all plots
along a single axis.
}
}

\examples{
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    anno_top() +
    align_dendro()
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    anno_top() +
    align_dendro(k = 3L)
}
\seealso{
\itemize{
\item \code{\link[=dendrogram_data]{dendrogram_data()}}
\item \code{\link[=hclust2]{hclust2()}}
}
}
