% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-.R
\name{layout-operator}
\alias{layout-operator}
\alias{&,Layout,ANY-method}
\alias{&.Layout}
\alias{&.HeatmapLayout}
\alias{&.ggheatmap}
\alias{&.StackLayout}
\alias{&.ggstack}
\alias{-,Layout,ANY-method}
\alias{-.Layout}
\alias{-.HeatmapLayout}
\alias{-.ggheatmap}
\alias{-.StackLayout}
\alias{-.ggstack}
\title{Plot arithmetic}
\usage{
\S4method{&}{Layout,ANY}(e1, e2)

\S4method{-}{Layout,ANY}(e1, e2)
}
\arguments{
\item{e1}{A \code{\link[=layout_heatmap]{layout_heatmap()}} or \code{\link[=layout_stack]{layout_stack()}} object.}

\item{e2}{An object to be added to the plot.}
}
\value{
A modified \code{Layout} object.
}
\description{
Plot arithmetic
}
\details{
In order to reduce code repetition \code{ggalign} provides two operators for
adding ggplot elements (geoms, themes, facets, etc.) to multiple/all plots in
\code{\link[=layout_heatmap]{layout_heatmap()}} or \code{\link[=layout_stack]{layout_stack()}} object.

Like \code{patchwork}, \code{&} add the element to all plots in the plot. If the
element is a \link[ggplot2:theme]{theme}, this will also modify the layout theme.

Unlike \code{patchwork}, the \code{-} operator adds ggplot2 elements (geoms, themes,
facets, etc.) rather than a ggplot plot. The key difference between \code{&} and
\code{-} is in how they behave in \code{\link[=layout_heatmap]{layout_heatmap()}}. The \code{-} operator only
applies the element to the current active context in \code{\link[=layout_heatmap]{layout_heatmap()}}.
Using \code{-} might seem unintuitive if you think of the operator as "subtract",
the underlying reason is that \code{-} is the only operator in the same precedence
group as \code{+}.
}
\examples{
mat <- matrix(rnorm(81), nrow = 9)
ggheatmap(mat) +
    hmanno("top") +
    align_dendro() &
    theme(panel.border = element_rect(
        colour = "red", fill = NA, linewidth = unit(2, "mm")
    ))
ggheatmap(mat) +
    hmanno("top") +
    align_dendro() -
    theme(panel.border = element_rect(
        colour = "red", fill = NA, linewidth = unit(2, "mm")
    ))

}
