% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gg_partial_coplot.ggRandomForests.R
\name{gg_partial_coplot.ggRandomForests}
\alias{gg_partial_coplot}
\alias{gg_partial_coplot.ggRandomForests}
\title{Data structures for stratified partial coplots}
\usage{
gg_partial_coplot.ggRandomForests(object, xvar, groups, surv_type = c("mort",
  "rel.freq", "surv", "years.lost", "cif", "chf"), time, ...)
}
\arguments{
\item{object}{randomForestSRC::rfsrc object}

\item{xvar}{list of partial plot variables}

\item{groups}{vector of stratification variable.}

\item{surv_type}{for survival random forests,  c("mort", "rel.freq", "surv",
"years.lost", "cif", "chf")}

\item{time}{vector of time points for survival random forests partial plots.}

\item{...}{extra arguments passed to randomForestSRC::plot.variable function}
}
\value{
\code{gg_partial_coplot} object. An subclass of a
\code{\link{gg_partial_list}} object
}
\description{
Data structures for stratified partial coplots
}
\examples{
\dontrun{
data(rfsrc_pbc, package="ggRandomForests")

# Create a 3d coplot, survival as a function of bilirubin and prothrombin
prothrombin_grp <- cut(rfsrc_pbc$xvar$prothrombin, breaks=c(8.9,10,11,12,18))

gg_dta <- gg_partial_coplot(rfsrc_pbc, xvar="bili", groups=prothrombin_grp,
  surv_type="surv", time=1, show.plots=FALSE)

ggpl <- ggplot(gg_dta,
               aes(x=bili, y=yhat, shape=groups, color=groups))+
       geom_point()+geom_smooth(se=FALSE)+
       labs(x="Surgical Date", y="Survival 1 year",
            shape="Prothrombin", color="Prothrombin")+
       scale_color_brewer(palette="Set1")

ggpl

## Build a list of 25 split points
prothrom <- rfsrc_pbc$xvar \%>\% filter(!is.na(prothrombin))
n.x <- length(unique(prothrom$prothrombin))
npts <- 25
prothrombin_pts <- sort(unique(prothrom$prothrombin))[
   unique(as.integer(seq(1, n.x, length = min(npts, n.x))))]

# Create a 3d coplot, survival as a function of bilirubin and prothrombin
prothrombin_grp <- cut(rfsrc_pbc$xvar$prothrombin, breaks=prothrombin_pts)

gg_dta <- gg_partial_coplot(rfsrc_pbc, xvar="bili", groups=prothrombin_grp,
  surv_type="surv", time=1, show.plots=FALSE)

ggpl <- ggplot(gg_dta,
               aes(x=bili, y=yhat, shape=groups, color=groups))+
       geom_point()+geom_smooth(se=FALSE)+
       labs(x="Surgical Date", y="Survival 1 year",
            shape="Prothrombin", color="Prothrombin")+
       scale_color_brewer(palette="Set1")

ggpl

}
}

