% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstack.R
\name{column_info_table}
\alias{column_info_table}
\title{Parse a tibble and ensure it meets standards}
\usage{
column_info_table(
  data,
  maxlevels = 6,
  col_id = NULL,
  cols_to_plot,
  tooltip_column_suffix = "_tooltip",
  ignore_column_regex = "_ignore$",
  palettes,
  colours_default,
  colours_default_logical,
  verbose
)
}
\arguments{
\item{data}{data.frame to autoplot (data.frame)}

\item{maxlevels}{for categorical variables, what is the maximum number of distinct values to allow (too many will make it hard to find a palette that suits). (number)}

\item{col_id}{name of column to use as an identifier. If null, artificial IDs will be created based on row-number.}

\item{cols_to_plot}{names of columns in \strong{data} that should be plotted. By default plots all valid columns (character)}

\item{tooltip_column_suffix}{the suffix added to a column name that indicates column should be used as a tooltip (string)}

\item{ignore_column_regex}{a regex string that, if matches a column name,  will cause that  column to be excluded from plotting (string). If NULL no regex check will be performed. (default: "_ignore$")}

\item{palettes}{A list of named vectors. List names correspond to \strong{data} column names (categorical only). Vector names to levels of columns. Vector values are colours, the vector names are used to map values in data to a colour.}

\item{colours_default}{Default colors for categorical variables without a custom palette.}

\item{colours_default_logical}{Colors for binary variables: a vector of three colors representing \code{TRUE}, \code{FALSE}, and \code{NA} respectively (character).}

\item{verbose}{Numeric value indicating the verbosity level:
\itemize{
\item \strong{2}: Highly verbose, all messages.
\item \strong{1}: Key messages only.
\item \strong{0}: Silent, no messages.
}}
}
\value{
tibble with the following columns:
\enumerate{
\item colnames
\item coltype (categorical/numeric/tooltip/invalid)
\item ndistinct (number of distinct values)
\item plottable (should this column be plotted)
\item tooltip_col (the name of the column to use as the tooltip) or NA if no obvious tooltip column found
}
}
\description{
Parse a tibble and ensure it meets standards
}
