% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction_effects.R
\name{interaction_effects}
\alias{interaction_effects}
\title{Two-Factor interaction effects plot for a factorial design}
\usage{
interaction_effects(
  design,
  response,
  exclude_vars = c(),
  linetypes = c("solid", "dashed"),
  colors = c("#4260c9", "#d6443c"),
  n_columns = 2,
  showplot = TRUE
)
}
\arguments{
\item{design}{Design of experiment (Factorial Design)}

\item{response}{A character string indicating the response of the data}

\item{exclude_vars}{A vector containing variables to exclude}

\item{linetypes}{Change linetypes. Default are ('solid','dashed)}

\item{colors}{Change color of lines/points. Default are ("#4260c9" ,"#d6443c")}

\item{n_columns}{number of columns for facet grid. Default is 2}

\item{showplot}{logical indicating to show the interaction effect plots. If false, a list of tibbles is returned used to obtain the interaction effects for each factor. Default is TRUE}
}
\value{
interaction effects plot between two factors
}
\description{
Two-Factor interaction effects plot for a factorial design
}
\examples{
interaction_effects(adapted_epitaxial,response = 'ybar',exclude_vars = c('s2','lns2'))
}
