% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{lsat_cache}
\alias{lsat_cache}
\alias{lsat_cache_delete}
\alias{lsat_cache_delete_all}
\alias{lsat_cache_details}
\alias{lsat_cache_list}
\title{Manage cached files}
\usage{
lsat_cache_list()

lsat_cache_delete(files, force = TRUE)

lsat_cache_delete_all(force = TRUE)

lsat_cache_details(files = NULL)
}
\arguments{
\item{files}{(character) one or more complete file names}

\item{force}{(logical) Should files be force deleted? Default: \code{TRUE}}
}
\description{
Manage cached files
}
\details{
\code{cache_delete} only accepts 1 file name, while \code{cache_delete_all}
doesn't accept any names, but deletes all files. For deleting many specific files,
use \code{cache_delete} in a \code{\link{lapply}} type call

We cache using \code{\link[rappdirs]{user_cache_dir}}, find your cache
folder by executing \code{rappdirs::user_cache_dir("landsat-pds")}
}
\section{Functions}{

\itemize{
 \item \code{lsat_cache_list()} returns a character vector of full path file names
 \item \code{lsat_cache_delete()} deletes one or more files, returns nothing
 \item \code{lsat_cache_delete_all()} delete all files, returns nothing
 \item \code{lsat_cache_details()} prints file name and file size for each file,
 supply with one or more files, or no files (and get details for all available)
}
}
\examples{
\dontrun{
# list files in cache
lsat_cache_list()

# List info for single files
lsat_cache_details(files = lsat_cache_list()[1])
lsat_cache_details(files = lsat_cache_list()[2])

# List info for all files
lsat_cache_details()

# delete files by name in cache
# lsat_cache_delete(files = lsat_cache_list()[1])

# delete all files in cache
# lsat_cache_delete_all()
}
}

