% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{summarise_analysis}
\alias{summarise_analysis}
\title{Summarise analyses of simulations of time-to-event data using arbitrary event, censoring and recruitment distributions.}
\usage{
summarise_analysis(analysed_results, alpha1 = 0.025)
}
\arguments{
\item{analysed_results}{Output file from analyse_sim. Only analyse_sim output is supported.}

\item{alpha1}{1-sided alpha to be used for analysis. Default=0.025.}
}
\value{
Returns a table with one row. Table contains the following columns:
\itemize{
 \item{"Simulations"}{ Number of simulations conducted}
 \item{"HR"}{ Exponent of Mean Cox Log Hazard Ratio (LR/Cox analysis only)}
 \item{"LogHR"}{ Mean Cox Log Hazard Ratio (LR/Cox analysis only)}
 \item{"LogHR_SE"}{ Root mean square of the Cox Standard Errors for Log Hazard Ratio (LR/Cox analysis only)}
 \item{"HR_Z"}{ Mean Cox Z-Score (LR/Cox analysis only)}
 \item{"HR_P"}{ p-value of Mean Cox Z-Score (LR/Cox analysis only)}
 \item{"HR_Power"}{ Simulated power of Cox-regression (LR/Cox analysis only)}
 \item{"HR_Failed"}{ Proportion of simulations failing to calculate a Cox HR (LR/Cox analysis only)}
 \item{"LR_Z"}{ Mean Log-Rank Test Z-Score (LR/Cox analysis only)}
 \item{"LR_P"}{ p-value of Mean Log-Rank Test Z-Score (LR/Cox analysis only)}
 \item{"LR_Power"}{ Simulated power of the log-rank test (LR/Cox analysis only)}
 \item{"LR_Failed"}{ Proportion of simulations failing to calculate a log-rank test statistic (LR/Cox analysis only)}
 \item{"Events_Active"}{ Mean events in active arm (LR/Cox analysis only)}
 \item{"Events_Control"}{ Mean events in control arm (LR/Cox analysis only)}
 \item{"Events_Total"}{ Mean total events(LR/Cox analysis only)}
 \item{"RMST_Time"}{ Restriction time for RMST analysis (RMST analysis only)}
 \item{"RMST_Control"}{ Mean RMST for active arm (RMST analysis only)}
 \item{"RMST_C_SE"}{ Root mean square of RMST Standard Errors for active arm (RMST analysis only)}
 \item{"RMST_Active"}{ Mean RMST for control arm (RMST analysis only)}
 \item{"RMST_A_SE"}{ Root mean square of RMST Standard Errors for control arm (RMST analysis only)}
 \item{"RMST_Delta"}{ Mean RMST difference between arms active-control (RMST analysis only)}
 \item{"RMST_D_SE"}{ Root mean square of RMST difference Standard Errors (RMST analysis only)}
 \item{"RMST_Power"}{ Simulated power of RMST (RMST analysis only)}
 \item{"RMST_Failed"}{ Proportion of simulations failing to calculate the RMST (RMST analysis only)}
 \item{"LM_Time"}{ Landmark analysis time, i.e. assessment time of Survival function (Landmark analysis only)}
 \item{"LM_Control"}{ Mean survival function for active arm at landmark time (Landmark analysis only)}
 \item{"LM_C_SE"}{ Root mean square of Greenwood standard errors for active arm at landmark time (Landmark analysis only)}
 \item{"LM_Active"}{ Mean survival function for control arm at landmark time (Landmark analysis only)}
 \item{"LM_A_SE"}{ Root mean square of Greenwood standard errors for control arm at landmark time (Landmark analysis only)}
 \item{"LM_Delta"}{ Mean survival function difference active-control at landmark time (Landmark analysis only)}
 \item{"LM_D_SE"}{ Root mean square of Greenwood standard errors for survival differences at landmark time (Landmark analysis only)}
 \item{"LM_Power"}{ Power of landmark analysis (Landmark analysis only)}
 \item{"LM_Failed"}{ Proportion of simulations failing to calculate the survival difference at landmark time (Landmark analysis only)}
}
}
\description{
Function for summarising the analyses of simulated time-to-event trial data produced by analyse_sim.\cr
Automatically reads in format from analyse_sim; no other input format is supported.\cr
Automatically detects types of analysis performed and provides relevant summaries (log-rank, Cox, RMST, landmark).\cr
}
\examples{
example_sim <- simulate_trials(active_ecurve=Weibull(250,0.8),control_ecurve=Weibull(100,1),
rcurve=LinearR(12,100,100), assess=40, iterations=5,seed=12345,detailed_output=TRUE)

example_analysis1 <- analyse_sim(example_sim)
example_analysis2 <- analyse_sim(data=example_sim,RMST=30,landmark=30)

example_summary1 <- summarise_analysis(example_analysis1)
example_summary2 <- summarise_analysis(example_analysis2)
}
\author{
James Bell
}
