% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.R
\name{git_tag}
\alias{git_tag}
\alias{git_tag_list}
\alias{git_tag_create}
\alias{git_tag_delete}
\alias{git_tag_push}
\title{Git Tag}
\usage{
git_tag_list(match = "*", repo = ".")

git_tag_create(name, message, ref = "HEAD", repo = ".")

git_tag_delete(name, repo = ".")

git_tag_push(name, ..., repo = ".")
}
\arguments{
\item{match}{pattern to filter tags (use \code{*} for wildcard)}

\item{repo}{The path to the git repository. If the directory is not a
repository, parent directories are considered (see \link{git_find}). To disable
this search, provide the filepath protected with \code{\link[=I]{I()}}.}

\item{name}{tag name}

\item{message}{tag message}

\item{ref}{target reference to tag}

\item{...}{other arguments passed to \link{git_push}}
}
\description{
Create and list tags.
}
\seealso{
Other git: 
\code{\link{git_archive}},
\code{\link{git_branch}()},
\code{\link{git_commit}()},
\code{\link{git_config}()},
\code{\link{git_diff}()},
\code{\link{git_fetch}()},
\code{\link{git_merge}()},
\code{\link{git_rebase}()},
\code{\link{git_remote}},
\code{\link{git_repo}},
\code{\link{git_signature}()},
\code{\link{git_stash}}
}
\concept{git}
