% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractals.R
\name{countQuakes}
\alias{countQuakes}
\title{count the number of earthquakes per year}
\usage{
countQuakes(qdat, minmag, from, to)
}
\arguments{
\item{qdat}{a data frame containing columns named \code{mag} and
\code{year}.}

\item{minmag}{minimum magnitude}

\item{from}{first year}

\item{to}{last year}
}
\value{
a table with the number of earthquakes per year
}
\description{
Counts the number of earthquakes per year that fall
    within a certain time interval.
}
\examples{
data(declustered,package='geostats')
quakesperyear <- countQuakes(declustered,minmag=5.0,from=1917,to=2016)
table(quakesperyear)
}
