% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{edges}
\alias{edges}
\title{Edge list}
\usage{
edges(C, unique_pairs_only = TRUE)
}
\arguments{
\item{C}{A connectivity matrix where connection between two nodes is indicated by non-zero entries.}

\item{unique_pairs_only}{By default, only unique pairs of nodes (i, j) will be included in the output.}
}
\value{
Returns a \code{data.frame} with three columns. The first two columns (\code{node1} and \code{node2}) contain the indices of connected pairs of nodes; only unique pairs of nodes are included (unless \code{unique_pairs_only = FALSE}). The third column (\code{weight}) contains the corresponding matrix element, \code{C[node1, node2]}.
}
\description{
Creates a list of connected nodes following the graph representation of a spatial connectivity matrix.
}
\details{
This is used internally for \code{\link[geostan]{stan_icar}} and it is also helpful for creating the scaling factor for BYM2 models fit with \code{\link[geostan]{stan_icar}}.
}
\examples{
data(sentencing)
C <- shape2mat(sentencing)
nbs <- edges(C)
head(nbs)

## similar to:
head(Matrix::summary(C))
head(Matrix::summary(shape2mat(georgia, "W")))
}
\seealso{
\code{\link[geostan]{shape2mat}}, \code{\link[geostan]{prep_icar_data}}, \code{\link[geostan]{stan_icar}}
}
