% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geos-unary-geometry.R
\name{geos_centroid}
\alias{geos_centroid}
\alias{geos_boundary}
\alias{geos_minimum_width}
\alias{geos_minimum_clearance_line}
\alias{geos_minimum_rotated_rectangle}
\alias{geos_unary_union}
\alias{geos_unary_union_prec}
\alias{geos_coverage_union}
\alias{geos_point_on_surface}
\alias{geos_node}
\alias{geos_make_valid}
\alias{geos_unique_points}
\alias{geos_reverse}
\alias{geos_merge_lines}
\alias{geos_build_area}
\alias{geos_envelope}
\alias{geos_envelope_rct}
\alias{geos_convex_hull}
\alias{geos_point_start}
\alias{geos_point_end}
\alias{geos_clone}
\alias{geos_set_srid}
\alias{geos_point_n}
\alias{geos_simplify}
\alias{geos_simplify_preserve_topology}
\alias{geos_set_precision}
\alias{geos_normalize}
\alias{geos_clip_by_rect}
\title{Geometry transformers}
\usage{
geos_centroid(geom)

geos_boundary(geom)

geos_minimum_width(geom)

geos_minimum_clearance_line(geom)

geos_minimum_rotated_rectangle(geom)

geos_unary_union(geom)

geos_unary_union_prec(geom, grid_size)

geos_coverage_union(geom)

geos_point_on_surface(geom)

geos_node(geom)

geos_make_valid(geom)

geos_unique_points(geom)

geos_reverse(geom)

geos_merge_lines(geom)

geos_build_area(geom)

geos_envelope(geom)

geos_envelope_rct(geom)

geos_convex_hull(geom)

geos_point_start(geom)

geos_point_end(geom)

geos_clone(geom)

geos_set_srid(geom, srid)

geos_point_n(geom, index)

geos_simplify(geom, tolerance)

geos_simplify_preserve_topology(geom, tolerance)

geos_set_precision(
  geom,
  grid_size,
  preserve_topology = TRUE,
  keep_collapsed = FALSE
)

geos_normalize(geom)

geos_clip_by_rect(geom, rect)
}
\arguments{
\item{geom}{A \link[=as_geos_geometry]{GEOS geometry vector}}

\item{grid_size}{For \verb{_prec()} variants, the grid size such that all vertices of
the resulting geometry will lie on the grid.}

\item{srid}{An integer spatial reference identifier.}

\item{index}{The index of the point or geometry to extract.}

\item{tolerance}{A minimum distance to use for simplification. Use a higher
value for more simplification.}

\item{preserve_topology}{Should topology internal to each feature
be preserved?}

\item{keep_collapsed}{Should items that become EMPTY due to rounding
be kept in the output?}

\item{rect}{A \code{list()} representing rectangles in the form
\code{list(xmin, ymin, xmax, ymax)}. List items with length 1 will be
recycled to the length of the longest item.}
}
\value{
A \link[=as_geos_geometry]{GEOS geometry vector} of length \code{geom}
}
\description{
Geometry transformers
}
\examples{
geos_centroid(c("POINT (0 1)", "LINESTRING (0 0, 1 1)"))
geos_boundary(c("POLYGON ((0 0, 1 0, 0 1, 0 0))", "LINESTRING (0 0, 1 1)"))
geos_minimum_width("POLYGON ((0 0, 1 0, 0 1, 0 0))")
geos_minimum_clearance_line("POLYGON ((0 0, 10 0, 10 10, 3 5, 0 10, 0 0))")
geos_minimum_rotated_rectangle("POLYGON ((0 0, 1 0, 0.5 0.5, 0 0))")
geos_minimum_bounding_circle("LINESTRING (-1 -1, 1 1)")
geos_unary_union("MULTIPOINT (0 1, 0 1)")
geos_point_on_surface("LINESTRING (0 1, 0.2 3, 10 10)")
geos_node("POLYGON ((0 0, 1 0, 0 1, 0 0))")
geos_make_valid("POLYGON ((0 0, 1 1, 1 0, 0 1, 0 0))")
geos_unique_points("POLYGON ((0 0, 1 0, 0 1, 0 0))")
geos_reverse("LINESTRING (0 0, 1 1)")
geos_merge_lines(
  "MULTILINESTRING ((0 0, 0.5 0.5, 2 2), (0.5 0.5, 2 2))"
)
geos_build_area("LINESTRING (0 0, 1 0, 0 1, 0 0)")
geos_envelope("LINESTRING (0 0, 1 2)")
geos_convex_hull("MULTIPOINT (0 0, 1 0, 0 2, 0 0)")
geos_point_start("LINESTRING (0 0, 1 1)")
geos_point_end("LINESTRING (0 0, 1 1)")

geos_simplify("LINESTRING (0 0, 0 1, 0 2)", 0.1)
geos_simplify_preserve_topology("LINESTRING (0 0, 0 1, 0 2)", 0.1)

}
