% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{intensity_pspline}
\alias{intensity_pspline}
\title{Intensity Estimation on Geometric Networks with Penalized Splines}
\usage{
intensity_pspline(
  X,
  ...,
  formula = ~1,
  delta = "0",
  h = "0.5",
  r = 2,
  scale = NULL,
  density = FALSE,
  verbose = FALSE,
  control = list()
)
}
\arguments{
\item{X}{A point pattern on a geometric network (object of class
\code{gnpp}). The data (\code{X$data}) must contain information on
all covariates included in \code{formula}.}

\item{...}{Other arguments. The following arguments must match exactly.}

\item{formula}{A one-sided formula (if a two-sided formula is supplied, the
left hand side of the formula is ignored). The formula can consist of either
linear terms as in linear models (\code{\link{lm}}) or smooth terms as
in \code{\link[mgcv]{gam}} formulae, where the usage is restricted to
smooth terms constructed with \code{\link[mgcv]{s}} and the argument
\code{bs} is set to
\code{bs = "ps"} by default, i.e. \code{intensity_pspline} can handle
penalized spline
based smooth terms.}

\item{delta}{The global knot distance \eqn{\delta}, a numerical vector of length one. If
not supplied, delta will be chosen properly according to the geometric
network \code{X} which is supplied.}

\item{h}{The global bin width \eqn{h}, a numerical vector of length one. If
not supplied, \code{h} will be chosen properly according to the geometric
network \code{X} which is supplied.}

\item{r}{The order of the penalty of the baseline intensity on the geometric
network, default to a penalty of order \code{r = 2}.}

\item{scale}{A named list which specifies the rescaling of network related
covariates. Currently, only x- and y-coordinates can be scaled.}

\item{density}{\code{TRUE} if the intensity should be normalized such that it
can be interpreted as a density, i.e. the integral over the estimated density
is equal to one.}

\item{verbose}{If \code{TRUE}, prints information on the process of the fitting
algorithm.}

\item{control}{A list of optional arguments which control the convergence
of the fitting algorithm. See "Details".}
}
\value{
A fitted geometric network (object of class \code{gnppfit}).
}
\description{
This is the main function of the \code{geonet} package.
\code{intensity_pspline} estimates the intensity of a point pattern on a
geometric network employing penalized splines as outlined in Schneble
and Kauermann (2020). In distinction to
\code{\link[spatstat.linnet]{density.lpp}} from the \code{spatstat.linnet} package,
which provides kernel based tools for intensity estimation of point
patterns on linear networks, \code{intensity_pspline} allows to
incorporate covariates while also estimating the baseline intensity.
Covariates can be either internal or external. External covariates
can also be incorporated as a smooth term using penalized splines
with the same syntax as in \code{\link[mgcv]{gam}}.
}
\examples{
library(geonet)
X <- runifgn(50, small_gn)
delta <- 0.2
model <- intensity_pspline(X, delta = delta)
summary(model)
plot(model)
}
\references{
Schneble, M. and G. Kauermann (2020). Intensity estimation on
geometric networks with penalized splines. arXiv preprint arXiv:2002.10270 .
}
\author{
Marc Schneble \email{marc.schneble@stat.uni-muenchen.de}
}
