% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.gn}
\alias{plot.gn}
\alias{plot.gnpp}
\alias{plot.gnppfit}
\title{Plot Methods for Geometric Network related Objects}
\usage{
\method{plot}{gn}(
  x,
  ...,
  title = "",
  title_x = "",
  title_y = "",
  size_lines = 1,
  frame = TRUE
)

\method{plot}{gnpp}(
  x,
  ...,
  covariate = NULL,
  title = "",
  title_x = "",
  title_y = "",
  size_lines = 1,
  size_points = 1,
  frame = TRUE
)

\method{plot}{gnppfit}(
  x,
  ...,
  select = NULL,
  title = "",
  title_x = "x",
  title_y = "y",
  size_lines = 1,
  frame = TRUE,
  sol = 100,
  scale = "log"
)
}
\arguments{
\item{x}{An object which is related to a geometric network
(object of class \code{gn}, \code{gnpp} or \code{gnppfit}).}

\item{...}{Other arguments.}

\item{title}{Main title of the plot.}

\item{title_x}{x-axis title (ignored if \code{frame = FALSE}).}

\item{title_y}{y-axis title (ignored if \code{frame = FALSE}).}

\item{size_lines}{Plotting size of the line segments. This specifies the
\code{size} argument of \code{\link[ggplot2]{geom_segment}}.}

\item{frame}{Should a frame be drawn around the network?}

\item{covariate}{Character vector of length 1, name of the covariate
that should be plotted.}

\item{size_points}{Plotting size of the point pattern. This specifies the
\code{size} argument of \code{\link[ggplot2]{geom_point}}.}

\item{select}{Allows the plot for a single model term to be selected for
printing. e.g. if you just want the plot for the second smooth term set
\code{select = 2}.}

\item{sol}{Solution of the color network plot.}

\item{scale}{The scale on which smooth terms should be plotted, either on
the log scale (\code{scale = log}, default) or on the exp-scale
(\code{scale = exp}).}
}
\value{
Invisibly returns an object of class \code{ggplot} or a list
of \code{ggplot} objects.
}
\description{
\code{plot} method for geometric networks, point patterns on geometric
networks, or a fitted point process.
}
