% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_params.R
\name{static_text_params}
\alias{static_text_params}
\title{Set static parameters}
\usage{
static_text_params(
  .type = "text",
  text_only = FALSE,
  gap = NULL,
  upright = TRUE,
  halign = "center",
  offset = NULL,
  parse = FALSE,
  straight = FALSE,
  padding = unit(0.05, "inch"),
  text_smoothing = 0,
  rich = FALSE,
  remove_long = FALSE
)
}
\arguments{
\item{.type}{A \code{character(1)} with either \code{"text"} or \code{"label"}, which
decides what the default is going to be for the \code{gap} argument. If \code{"text"}
the default is \code{NA}, which means to dynamically decide. If \code{"label"}, the
\code{"gap"} argument should default to \code{FALSE}.}

\item{text_only}{A \code{logical(1)} indicating whether the path part should be
plotted along with the text (\code{FALSE}, the default). If \code{TRUE}, any
parameters or aesthetics relating to the drawing of the path will be
ignored.}

\item{gap}{A \code{logical(1)} which if \code{TRUE}, breaks the path into two sections
with a gap on either side of the label. If \code{FALSE}, the path is plotted
as a whole. Alternatively, if \code{NA}, the path will be broken if the string
has a \code{vjust} between 0 and 1, and not otherwise. The default for the label
variant is \code{FALSE} and for the text variant is \code{NA}.}

\item{upright}{A \code{logical(1)} which if \code{TRUE} (default), inverts any text
where the majority of letters would upside down along the path, to improve
legibility. If \code{FALSE}, the path decides the orientation of text.}

\item{halign}{A \code{character(1)} describing how multi-line text should be
justified. Can either be \code{"center"} (default), \code{"left"} or \code{"right"}.}

\item{offset}{A \code{\link[grid:unit]{unit}} object of length 1 to determine the
offset of the text from the path. If this is \code{NULL} (default), the \code{vjust}
parameter decides the offset. If not \code{NULL}, the \code{offset} argument
overrules the \code{vjust} setting.}

\item{parse}{A \code{logical(1)} which if \code{TRUE}, will coerce the labels into
expressions, allowing for plotmath syntax to be used.}

\item{straight}{A \code{logical(1)} which if \code{TRUE}, keeps the letters of a label
on a straight baseline and if \code{FALSE} (default), lets individual letters
follow the curve. This might be helpful for noisy paths.}

\item{padding}{A \code{\link[grid:unit]{unit}} object of length 1 to determine the
padding between the text and the path when the \code{gap} parameter trims the
path.}

\item{text_smoothing}{a \code{numeric(1)} value between 0 and 100 that smooths
the text without affecting the line portion of the geom. The default value
of \code{0} means no smoothing is applied.}

\item{rich}{A \code{logical(1)} whether to interpret the text as html/markdown
formatted rich text. Default: \code{FALSE}. See also the rich text section of
the details in \code{\link[=geom_textpath]{geom_textpath()}}.}

\item{remove_long}{if TRUE, labels that are longer than their associated
path will be removed.}
}
\value{
A \code{list} with the parameters.
}
\description{
This sets parameters for text on a path that aren't expected to change
during the construction of a grob.
}
\keyword{internal}
\keyword{rd_dots}
