% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.evol.rates.r
\name{compare.evol.rates}
\alias{compare.evol.rates}
\title{Comparing rates of shape evolution on phylogenies}
\usage{
compare.evol.rates(A, phy, gp, iter = 999)
}
\arguments{
\item{A}{A matrix (n x [p x k]) or 3D array (p x k x n) containing GPA-aligned coordinates for a set of specimens}

\item{phy}{A phylogenetic tree of {class phylo} - see \code{\link[ape]{read.tree}} in library ape}

\item{gp}{A factor array designating group membership}

\item{iter}{Number of iterations for significance testing}
}
\value{
An object of class "evolrate" returns a list with the following components: 
  \item{sigma.d.ratio}{The ratio of maximum to minimum evolutionary rates.}
  \item{P.value}{The significance level of the observed ratio.}
  \item{sigma.d.gp}{The phylogenetic evolutionary rate for each group of species on the phylogeny.}
  \item{random.sigma}{The sigma values found in random permutations of the resampling procedure.}
  \item{permutations}{The number of random permutations used.}
}
\description{
Function calculates rates of shape evolution for two or more groups of species on a phylogeny from a set of Procrustes-aligned specimens
}
\details{
The function compares rates of morphological evolution for two or more groups of species on a phylogeny, under a 
 Brownian motion model of evolution. It is assumed that the landmarks have previously been aligned 
 using Generalized Procrustes Analysis (GPA) [e.g., with \code{\link{gpagen}}]. The approach is based on the distances
 between species in morphospace after phylogenetic transformation (Adams 2014). From the data the rate of shape evolution
 for each group is calculated, and a ratio of rates is obtained. If three or more groups of species are used, the ratio of 
 the maximum to minimum rate is used as a test statistic (see Adams 2014). Significance testing 
 is accomplished by phylogenetic simulation in which tips data are obtained under Brownian motion using a common 
 evolutionary rate pattern for all species on the phylogeny. Specifically, the common evolutionary rate matrix for all
 species is used, with the multi-dimensional rate used along the diagonal elements (see Denton and Adams 2015). This procedure is
 more general than the original simulation procedure, and retains the desirable statistical properties of earlier methods, 
 and under a wider array of data types.  
 If three or more groups of species are used, pairwise p-values are also calculated. The function can be used to obtain a 
 rate for the whole dataset of species by using a dummy group factor assigning all species to one group.
 
 This function can be used with univariate data (i.e. centroid size) if imported as matrix with rownames
 giving the taxa names.
 
 The generic functions, \code{\link{print}}, \code{\link{summary}}, and \code{\link{plot}} all work with \code{\link{compare.evol.rates}}.
 The generic function, \code{\link{plot}}, produces a histogram of random rate-ratios associated with
 the resampling procedure.

\subsection{Notes for geomorph 3.0}{ 
Compared to older versions of geomorph, the order of input variables has changed, so that it is consistent with other functions
in the program.  Additionally, for 3 or more groups, the pairwise p-values are found in the output object.}
}
\examples{
data(plethspecies) 
Y.gpa<-gpagen(plethspecies$land)    #GPA-alignment    
 gp.end<-factor(c(0,0,1,0,0,1,1,0,0))  #endangered species vs. rest
 names(gp.end)<-plethspecies$phy$tip

ER<-compare.evol.rates(A=Y.gpa$coords, phy=plethspecies$phy,gp=gp.end,iter=999)
summary(ER)
plot(ER)
}
\author{
Dean Adams & Emma Sherratt
}
\references{
Adams, D.C. 2014. Quantifying and comparing phylogenetic evolutionary rates for 
 shape and other high-dimensional phenotypic data. Syst. Biol. 63:166-177.

Denton, J.S.S., and D.C. Adams. 2015. A new phylogenetic test for comparing 
multiple high-dimensional evolutionary rates suggests interplay of evolutionary rates and 
modularity in lanternfishes (Myctophiformes; Myctophidae). Evolution. 69:2425-2440.
}
\keyword{analysis}

