% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{metro_map}
\alias{metro_map}
\title{Map of Washington DC Metro area}
\format{A data frame of three variables of length 1638400:
\itemize{
\item x: Numeric variable containing degree of longitude
\item y: Numeric variable containing degree of latitude
\item fill: Character variable containing fill color in HEX form for that tile location
}}
\usage{
metro_map
}
\description{
A dataset containing information to draw a map of Rockville, MD, and vicinity using \code{geom_tile}.
This information was pulled from Google Maps using the \pkg{ggmap} package.
}
\examples{
\dontrun{
ggplot(data = metro_map, aes(x = x, y = y)) +
geom_raster(fill = metro_map$fill, alpha = 0.75)
}
}
\references{
D. Kahle and H. Wickham. ggmap: Spatial Visualization with ggplot2.
The R Journal, 5(1), 144-161. \url{http://journal.r-project.org/archive/2013-1/kahle-wickham.pdf}
}
\keyword{datasets}

