% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOKeywords.R
\docType{class}
\name{ISOKeywords}
\alias{ISOKeywords}
\title{ISOKeywords}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a ISO set of keywords
}
\description{
ISOKeywords
}
\section{Fields}{

\describe{
\item{\code{keyword}}{[\code{\link{character}}] keyword(s)}

\item{\code{type}}{[\code{\link{ISOKeywordType}}] keyword type}

\item{\code{thesaurusName}}{[\code{\link{ISOCitation}}] thesaurus citation}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOKeywords
 }
 \item{\code{addKeyword(keyword, locales)}}{
   Adds a keyword. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{delKeyword(keyword, locales)}}{
   Deletes a keyword. Locale names can be specified as \code{list}
   with the \code{locales} argument. Local names should match those
   of the keyword to be deleted, otherwise nothing will be deleted.
 }
 \item{\code{setKeywordType(keywordType)}}{
   Sets the keyword type
 }
 \item{\code{setThesaurusName(thesaurusName)}}{
   Sets the thesaurus name
 }
}
}

\examples{
  #a basic keyword set
  md <- ISOKeywords$new()
  md$addKeyword("keyword1")
  md$addKeyword("keyword2")
  md$setKeywordType("theme")
  th <- ISOCitation$new()
  th$setTitle("General")
  md$setThesaurusName(th)
  xml <- md$encode()
  
  #a keyword set with anchors
  md <- ISOKeywords$new()
  kwd1 <- ISOAnchor$new(
    name = "keyword1",
    href = "http://myvocabulary.geometa/keyword1"
  )
  md$addKeyword(kwd1)
  kwd2 <- ISOAnchor$new(
    name = "keyword2",
    href = "http://myvocabulary.geometa/keyword2"
  )
  md$addKeyword(kwd2)
  md$setKeywordType("theme")
  xml <- md$encode()
  
  #Example for INSPIRE (GEMET Spatial Data Theme)
  inspire_kwd <- ISOKeywords$new()
  anc1 <- ISOAnchor$new(
    name = "Environmental monitoring facilities",
    href = "http://inspire.ec.europa.eu/theme/ef"
  )
  inspire_kwd$addKeyword(anc1)
  inspire_kwd$setKeywordType("theme")
  th <- ISOCitation$new()
  th$setTitle(
    ISOAnchor$new(
     name = "GEMET - INSPIRE themes, version 1.0",
     href="http://www.eionet.europa.eu/gemet/inspire_themes"
    )
  )
  inspire_date <- ISODate$new()
  inspire_date$setDate(as.Date("2008-06-01"))
  inspire_date$setDateType("publication")
  th$addDate(inspire_date)
  inspire_kwd$setThesaurusName(th)
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{keywords}
