% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOUsage.R
\docType{class}
\name{ISOUsage}
\alias{ISOUsage}
\title{ISOUsage}
\format{\code{\link{R6Class}} object.}
\usage{
ISOUsage
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Usage
}
\description{
ISOUsage
}
\section{Fields}{

\describe{
\item{\code{specificUsage}}{[\code{\link{character}}] a text giving a specific usage}

\item{\code{usageDateTime}}{[\code{\link{POSIXt}}] the datetime of the usage}

\item{\code{userDeterminedLimitations}}{[\code{\link{character}}] limitations determined by user}

\item{\code{userContactInfo}}{[\code{\link{ISOResponsibleParty}}] the user contact}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOUsage}}
 }
 \item{\code{setSpecificUsage(specificUsage, locales)}}{
   Set the specific usage, as \code{\link{character}} object. 
 }
 \item{\code{setUsageDateTime(usageDateTime)}}{
   Set the usage date time, object of class \code{\link{POSIXt}}
 }
 \item{\code{setUserDeterminedLimitations(userDeterminedLimitations, locales)}}{
   Set the limitations determined by user
 }
 \item{\code{addUserContact(contact)}}{
   Adds user contact, object of class \code{\link{ISOResponsibleParty}}
 }
 \item{\code{delUserContact(contact)}}{
   Deletes user contact, object of class \code{\link{ISOResponsibleParty}}
 }
}
}

\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{usage}
