% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/neighbours.R
\name{gh_neighbours}
\alias{east}
\alias{gh_neighbours}
\alias{neighbours}
\alias{north}
\alias{northeast}
\alias{northwest}
\alias{south}
\alias{southeast}
\alias{southwest}
\alias{west}
\title{Get neighbours to geohashes}
\usage{
gh_neighbours(hashes)

north(hashes)

northeast(hashes)

east(hashes)

southeast(hashes)

south(hashes)

southwest(hashes)

west(hashes)

northwest(hashes)
}
\arguments{
\item{hashes}{a vector of geohashes, which can be computed with \code{\link{gh_encode}}}
}
\description{
Geohashes are calculated using a fixed-sized box, which means it's easy
to take a geohash and extract the neighbouring boxes around it, in each direction.
These functions either extract all neighbours, or individual neighbours, depending on
your preference.
}
\examples{
#Get a single neighbours
north("ezs42")

#Get all neighbours!
gh_neighbours("ezs42")
}
\seealso{
\code{\link{gh_encode}} for generating hashes and \code{\link{gh_decode}} for resolving
them into latitude and longitude pairs.
}

