% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscb_layer_get_layer.R
\name{get_geomultistar}
\alias{get_geomultistar}
\alias{get_geomultistar.uscb_layer}
\title{Get \code{geomultistar}}
\usage{
get_geomultistar(ul)

\method{get_geomultistar}{uscb_layer}(ul)
}
\arguments{
\item{ul}{A \code{uscb_layer} object.}
}
\value{
A \code{geomultistar} object.
}
\description{
Get all the layer group data in the form of a \code{geomultistar} object: It
contains fact and dimension tables, and a dimension with an associated
geographic layer.
}
\details{
The name of the facts is the layer group name.
}
\examples{
library(tidyr)

folder <- system.file("extdata", package = "geogenr")
folder <- stringr::str_replace_all(paste(folder, "/", ""), " ", "")
ua <- uscb_acs_5ye(folder = folder)
sa <- ua \%>\% get_statistical_areas()
# sa[6]
# [1] "New England City and Town Area Division"
ul <- uscb_layer(uscb_acs_metadata, ua = ua, geodatabase = sa[6], year = 2015)
layers <- ul \%>\% get_layer_names()
# layers[3]
# [1] "X02_RACE"
ul <- ul \%>\% get_layer(layers[3])
lg <- ul \%>\% get_layer_group_names()
# lg[2]
# [1] "003 - DETAILED RACE"
ul <- ul \%>\% get_layer_group(lg[2])

gms <- ul \%>\% get_geomultistar()

}
\seealso{


Other result generation functions: 
\code{\link{get_common_flat_table}()},
\code{\link{get_common_geomultistar}()},
\code{\link{get_flat_table}()}
}
\concept{result generation functions}
