% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levelplot.r, R/levelplotProcessedData.r,
%   R/levelplotRawData.r
\docType{methods}
\name{levelplot}
\alias{levelplot}
\alias{levelplot,Profile-method}
\alias{levelplotProcessedData}
\alias{levelplotProcessedDataWithTopo}
\alias{levelplotRawData}
\title{Levelplot of Geoelectrics Data}
\usage{
levelplot(x, data, ...)

\S4method{levelplot}{Profile}(x, dataType = "processed",
  withTopo = FALSE, xlab = "Length [m]", ylab = "Depth [m]",
  main = paste(x@title), col = colors, breaks = 18, trafo = log,
  backtrafo = exp, ...)

levelplotProcessedData(x, xlab = "Length [m]", ylab = "Depth [m]",
  main = paste(x@title, "without topography"), col = colors,
  breaks = 18, trafo = log, backtrafo = exp, ...)

levelplotProcessedDataWithTopo(x, xlab = "Length [m]",
  ylab = "Height [m]", main = paste(x@title, "with topography"),
  col = colors, breaks = 18, trafo = log, backtrafo = exp, ...)

levelplotRawData(x, xlab = "Length [m]", ylab = "Depth [m]",
  main = paste(x@title, "without topography (raw data)"), col = colors,
  trafo = log, ...)
}
\arguments{
\item{x}{profile object.}

\item{data}{is always NULL}

\item{...}{lattice levelplot arguments.}

\item{dataType}{specify whether 'processed' (default) or 'raw' data should be plotted}

\item{withTopo}{TRUE if topography information is plotted}

\item{xlab}{label for x-axes.}

\item{ylab}{label for y-axes.}

\item{main}{title to be plotted.}

\item{col}{vector of colors.}

\item{breaks}{number of color breaks.}

\item{trafo}{transformation to be done on data (default: log).}

\item{backtrafo}{back transformation to plot correct labels (default: exp).}
}
\description{
Plots the interpolated resistance values of the
geoelectrics data.
}
\examples{
data(sinkhole)

levelplot(sinkhole@profiles[[1]], dataType = 'processed', withTopo = FALSE)
levelplotLegendLabel()

levelplot(sinkhole@profiles[[1]], dataType = 'processed', withTopo = TRUE)
levelplotLegendLabel()

levelplot(sinkhole@profiles[[1]], dataType = 'raw')
levelplotLegendLabel()
}
\seealso{
\code{\link{Profile-class}}
}
