% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCMclass.R
\name{print.FCMres}
\alias{print.FCMres}
\title{print method for FCMres}
\usage{
\method{print}{FCMres}(x, ...)
}
\arguments{
\item{x}{A FCMres object, typically obtained from functions CMeans, GCMeans, SFCMeans, SGFCMeans}

\item{...}{not used}
}
\value{
A boolean, TRUE if x can be considered as a FCMres object, FALSE otherwise
  group
}
\description{
print a FCMres object
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
result <- CMeans(dataset, k = 5, m = 1.5, standardize = TRUE)
print(result, "FCMres")
}
