% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boostrap_clust_validation.R
\name{groups_matching}
\alias{groups_matching}
\title{Match the groups obtained from two classifications}
\usage{
groups_matching(object.x, object.y)
}
\arguments{
\item{object.x}{A FCMres object, or a simple membership matrix. It is used as the reference
for the ordering of the groups}

\item{object.y}{A FCMres object, or a simple membership matrix. The order of its groups will
be updated to match with the groups of object.x}
}
\value{
The FCMres object or the membership matrix provided for the parameter object.y with
the order of the groups updated.
}
\description{
Match the groups obtained from two classifications based on
the Jaccard index calculated on the membership matrices.
}
\details{
We can not expect to obtain the groups in the same order in each run
of a classification algorithm. This function can be used match the clusters of a first
classification with the most similar clusters in a second classification. Thus
it might be easier to compare the results of two algorithms or two runs of the
same algorithm.
}
\examples{
data(LyonIris)

#selecting the columns for the analysis
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14",
                   "Pct_65","Pct_Img","TxChom1564","Pct_brevet","NivVieMed")

#rescaling the columns
Data <- LyonIris@data[AnalysisFields]
for (Col in names(Data)){
  Data[[Col]] <- as.numeric(scale(Data[[Col]]))
}

Cmean <- CMeans(Data,4,1.5,500,standardize = FALSE, seed = 456, tol = 0.00001, verbose = FALSE)
Cmean2 <- CMeans(Data,4,1.5,500,standardize = FALSE, seed = 789, tol = 0.00001, verbose = FALSE)
ordered_Cmean2 <- groups_matching(Cmean,Cmean2)
}
