% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_conservation_units.R
\name{read_conservation_units}
\alias{read_conservation_units}
\title{Download official data of Brazilian conservation untis as an sf object.}
\usage{
read_conservation_units(date = 201909, simplified = TRUE, showProgress = TRUE)
}
\arguments{
\item{date}{A date number in YYYYMM format (Defaults to 201909)}

\item{simplified}{Logic FALSE or TRUE, indicating whether the function returns the
data set with 'original' resolution or a data set with 'simplified' borders (Defaults to TRUE).
For spatial analysis and statistics users should set simplified = FALSE. Borders have been
simplified by removing vertices of borders using st_simplify{sf} preserving topology with a dTolerance of 100.}

\item{showProgress}{Logical. Defaults to (TRUE) display progress bar}
}
\description{
This data set covers the whole of Brazil and it includes the polygons of all conservation untis present in Brazilian
territory. The last update of the data was 09-2019. The original
data comes from MMA and can be found at http://mapas.mma.gov.br/i3geo/datadownload.htm .
}
\examples{
\donttest{

library(geobr)

# Read conservation_units
  b <- read_conservation_units(date=201909)
}
}
\seealso{
Other general area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_census_tract}()},
\code{\link{read_country}()},
\code{\link{read_health_region}()},
\code{\link{read_immediate_region}()},
\code{\link{read_intermediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipality}()},
\code{\link{read_neighborhood}()},
\code{\link{read_region}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_statistical_grid}()},
\code{\link{read_weighting_area}()}
}
\concept{general area functions}
